/*************************************************************************
 *File          :  IDCCAStartMute.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDCCASTARTMUTE_H_
#define IDCCASTARTMUTE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/MuteAction.h"
/*******************************************************************************
 *
 * CLASS:ID_CCAStart_Mute
 *
 *******************************************************************************/

class ID_CCAStart_Mute: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_CCAStart_Mute(tU16 Requester,tU16 Resource,tU16 State,tU16 Reason)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: Resource,Source
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_CCAStart_Mute(tU16 requester,tU16 resource,tenMuteAction state,tU32 reason, tU16 sink) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_Mute), Requester(requester), Resource(resource), State(state), Reason(reason), Sink(sink)
   {
   }
   ;
   /**
    *The Integer values
    */
   tU16  Requester;
   tU16  Resource;
   tenMuteAction  State;
   tU32  Reason;
   tU16 Sink; //daw2hi added to transport also the Sink

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_CCAStart_Mute *clone() const
   {
      return new ID_CCAStart_Mute(*this);
   }
};

#endif /* IDCCASTARTMUTE_H_ */
