
/************************************************************************FA*
 *File         :  IDAudioPropertyOffset.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2014 RBEI
 *Author            : Puneeth M(RBEI/ECV)
 *---------------------------------------------------------------------------

 ************************************************************************/
#ifndef IDAUDIOPROPERTYOFFSET_H_
#define IDAUDIOPROPERTYOFFSET_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"

/*******************************************************************************
 *
 * CLASS:ID_SetAudioProperty
 *
 *******************************************************************************/

class ID_AudioPropertyOffset: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_AudioPropertyOffset(tU8 Source,tS32 OffSetValue)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: Source, OffSetValue
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_AudioPropertyOffset(tU8 source, tS32 offsetvalue) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_AudioPropertyOffset), OffSetValue(offsetvalue), Source(source)
   {
   }

  tS32 OffSetValue;
  tU8 Source;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual ID_AudioPropertyOffset* clone() const
   {
      return new ID_AudioPropertyOffset(*this);
   }
};

#endif /* IDAUDIOPROPERTYOFFSET_H_ */
