
/************************************************************************FA*
 *File       :  IDSetAudioRoute.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  7/9/2012   7:15:34 PM   Anu Sebastian       Initial version
 ************************************************************************/

#ifndef IDSETAUDIOROUTE_H_
#define IDSETAUDIOROUTE_H
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3Source.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"

/*******************************************************************************
 *
 * CLASS:MSG_SetAudioRoute
 *
 *******************************************************************************/

class MSG_SetAudioRoute: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_SetAudioRoute(tenStream enStream, tenSource enSource)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enStream,enSource
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  MSG_SetAudioRoute(tenStream enstream, tenSource ensource, tU16  resource) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetAudioRoute), enStream(enstream),enSource(ensource),Resource(resource)
    {
    }

  MSG_SetAudioRoute(const MSG_SetAudioRoute& pMsg) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetAudioRoute), enStream(pMsg.enStream), enSource(pMsg.enSource), Resource(pMsg.Resource)
    {
    }

  tenStream enStream;
  tenSource enSource;
  tU16  Resource;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_SetAudioRoute *clone() const
   {
      return new MSG_SetAudioRoute(*this);
   }
};

#endif /* IDSETAUDIOROUTE_H_ */
