/**
* @file ID_ArkamysParameter.h
* @author CM-AI wie1hi
* @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
* @addtogroup fc_audiomanager
* @{
*/

#ifndef ID_ARKAMYSPARAMETER_H_
#define ID_ARKAMYSPARAMETER_H_

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
//#include "../../DataTypes/TypeDefines/ADR3DiagType.h"

class ID_ArkamysParameter: public Message<PO_MessageConfig::enID>
{
public:
   ID_ArkamysParameter() : Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_ArkamysParameter),
      arkamysCommand(0), arkamysAddress(0), arkamysLength(0), arkamysValues(OSAL_NULL)
   {
   }

   tU32  arkamysCommand;
   tU32  arkamysAddress;
   tU32  arkamysLength;
   tS32* arkamysValues;

   /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_ArkamysParameter *clone() const
   {
      return new ID_ArkamysParameter(*this);
   }
};



#endif /* ID_ARKAMYSPARAMETER_H_ */
