/*
 * IDMaintenanceMode.h.h
 *
 *  Created on: Nov 16, 2012
 *      Author: hag2hi
 */

#ifndef IDMAINTENANCEMODE_H_
#define IDMAINTENANCEMODE_H_
#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3StreamType.h"

/*******************************************************************************
 *
 * CLASS:MSG_MaintenanceMode
 *
 *******************************************************************************/

class MSG_MaintenanceMode: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_MaintenanceMode(tenStream enStream, tU8 u8ModeMask)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enStream, u8ModeMask
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   MSG_MaintenanceMode(tenStream enstream, tU16 u16modemask) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_MaintenanceMode), enStream(enstream), u16ModeMask(u16modemask)
   {
   }

   tenStream enStream;
   tU16 u16ModeMask;

    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_MaintenanceMode* clone() const
   {
      return new MSG_MaintenanceMode(*this);
   }
};




#endif /* IDMAINTENANCEMODE_H_ */
