/*************************************************************************
 *File          :  ID_SetDiagFader.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  04/02/2013    Swati N       Initial version
 ************************************************************************/

#ifndef IDSETDIAGFADER_H_
#define IDSETDIAGFADER_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"


/*******************************************************************************
 *
 * CLASS:ID_SetDiagFader
 *
 *******************************************************************************/

class ID_SetDiagFader: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_SetDiagFader(tS8 Fader)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagAudioGainPhase enDiagAudioGainPhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_SetDiagFader(tS8 sFader) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetDiagFader), sFaderValue(sFader)
    {
    }

  tS8 sFaderValue;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_SetDiagFader *clone() const
  {
    return new ID_SetDiagFader(*this);
  }
};

#endif /* IDSETDIAGFADER_H_ */
