#ifndef IDSETDIAGBALANCE_H_
#define IDSETDIAGBALANCE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"


/*******************************************************************************
 *
 * CLASS:ID_SetDiagBalance
 *
 *******************************************************************************/

class ID_SetDiagBalance: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_SetDiagBalance(tS16 Balance)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagAudioGainPhase enDiagAudioGainPhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_SetDiagBalance(tS8 sBalance) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_SetDiagBalance), sBalanceValue(sBalance)
    {
    }

  tS8 sBalanceValue;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_SetDiagBalance *clone() const
  {
    return new ID_SetDiagBalance(*this);
  }
};

#endif /* IDSETDIAGBALANCE_H_ */
