/*************************************************************************
 *File          :  IDDiagAudioGain.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2018 RBEI
 *Author            : pau4kor
 *--------------------------------------------------------------------------
 Created by :  06/03/2018     Puneeth M       Initial version
 ************************************************************************/

#ifndef ID_DIAGBUZZER_H_
#define ID_DIAGBUZZER_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"


/*******************************************************************************
 *
 * CLASS:ID_DiagBuzzer
 *
 *******************************************************************************/

class ID_DiagBuzzer: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_DiagBuzzer(tenAudioGainPhase enAudioGainPhase)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagAudioGainPhase enDiagAudioGainPhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_DiagBuzzer(tS32 s32buzzerid, tBool bcontrolstate) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_DiagBuzzer), s32BuzzerId(s32buzzerid), bControlState(bcontrolstate)
    {
    }

  tS32 s32BuzzerId;
  tBool bControlState;


  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_DiagBuzzer *clone() const
  {
    return new ID_DiagBuzzer(*this);
  }
};

#endif /* ID_DIAGBUZZER_H_ */
