/*************************************************************************
 *File          :  ID_DiagActiveSink.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : pmh7kor
 *--------------------------------------------------------------------------
 Created by :  01/07/2016     pmh7kor       Initial version
 ************************************************************************/

#ifndef IDDIAG_ACTIVESINK_H_
#define IDDIAG_ACTIVESINK_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/DiagActiveSinkType.h"

/*******************************************************************************
 *
 * CLASS:ID_DiagActiveSink
 *
 *******************************************************************************/

class ID_DiagActiveSink: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_DiagActiveSink(tenDiagActiveSinkPhase endiagactivesinkphase)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagActiveSinkPhase enDiagActiveSinkPhase;
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_DiagActiveSink(tenDiagActiveSinkPhase endiagactivesinkphase) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_DiagActiveSink), enDiagActiveSinkPhase(endiagactivesinkphase)
    {
    }

  tenDiagActiveSinkPhase enDiagActiveSinkPhase;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_DiagActiveSink *clone() const
  {
    return new ID_DiagActiveSink(*this);
  }
};

#endif /* IDDIAG_ACTIVESINK_H_ */
