/*
 * ID_CCA_GetDiagResult.h
 *
 *  Created on: Mar 25, 2014
 *      Author: kma4hi
 */

#ifndef ID_CCA_GETDIAGRESULT_H_
#define ID_CCA_GETDIAGRESULT_H_

/*******************************************************************************
 *
 * Type declarations
 *
 *******************************************************************************/

enum tenTestResult
{
   // values from: midw_fi_tcl_e8_TestResult
   EN_PASSED = 0UL,
   EN_FAILED = 1UL,
   EN_NORESULT = 2UL,
   EN_PASSEDDIAGNOSTIC = 3UL,
   EN_FAILEDDIAGNOSTIC = 4UL,
   EN_NORESULTDIAGNOSTIC = 5UL,
   EN_DISABLE = 6UL,
   EN_ENABLE = 7UL
};

// -----------------------------------------------------------------------------

struct tTestResult
{
   tU16 u16ID;
   tenTestResult enResult;

   inline /* default constructor */ tTestResult()
      : u16ID(0), enResult(EN_NORESULT)
      {   }

   inline /* constructor */ tTestResult(tU16 _u16ID, tenTestResult _enResult)
      : u16ID(_u16ID), enResult(_enResult)
      {   }

   inline /* copy constructor */ tTestResult(const tTestResult& roRef)
      {  u16ID = roRef.u16ID;  enResult = roRef.enResult;  }

   inline tTestResult& /* assignment */ operator=(const tTestResult& roRef)
      {  if (this != &roRef) { u16ID = roRef.u16ID; enResult = roRef.enResult; } return *this;  }
};

// -----------------------------------------------------------------------------

typedef std::vector<tTestResult, std::allocator<tTestResult> > tTestResultList;
typedef std::vector<tU16, std::allocator<tU16> > tTestRequestList;

/*******************************************************************************
 *
 *                   IF _ D i a g R e s u l t - H a n d l e r
 *
 * interface of sub-component which takes a list of trouble codes
 * and forwards them to vd_diaglog
 *
 *******************************************************************************/

/* abstract */ class IF_DiagResultHandler
{
protected:
   static IF_DiagResultHandler*  _poInstance;

public:
   inline /* default constructor */ IF_DiagResultHandler()
      { if (NULL == _poInstance)  _poInstance = this; }

   /* inline */ virtual /* destructor */ ~IF_DiagResultHandler()
      {  if (this == _poInstance) _poInstance = NULL; }

   // provide a function which takes the diagnostic or internal trouble codes
   // and forward it to vd_diaglog
   virtual void vSaveDiagResult(tTestResultList& roResultList) = 0;

   // pointer to (first) instance of IF_DiagResultHandler
   //  - may be NULL if it is not up
   // use this for spontaneous, unrequested result savings
   static IF_DiagResultHandler* poGetDiagResultHandlerInstance();
};

/*******************************************************************************
 *
 *                     ID _ G e t - D i a g R e s u l t
 *
 * PO message to indicate a request for current DTCs / ITCs
 *
 *  - Provides a reference to the sub-component which takes the response
 *    (list of trouble codes) and forwards them to vd_diaglog. Buffer its address
 *    if you reply asynchronously.
 *
 *  - If the given list of requested ITCs is not empty, provide the mentioned TCs,
 *    otherwise provide all your component is responsible for.
 *    Running tests (if any) shall be canceled and restarted.
 *
 *  - Will be invoked twice: first when request is received from vd_diaglog
 *    and second (with TimeOut set to TRUE) when patience time has elapsed
 *
 *******************************************************************************/


class ID_CCA_GetDiagResult: public Message<PO_MessageConfig::enID>
{

public:
   // member variables
   IF_DiagResultHandler& roResultHandler;
   tTestRequestList& roRequestedITCs;
   bool const bTimeOutElapsed;

   // member functions
   /* constructor */ ID_CCA_GetDiagResult (IF_DiagResultHandler& _roResultHandler
     , tTestRequestList& _roRequestedITCs, bool _bTimeOutElapsed = false)
        : Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCA_GetDiagResult)
        , roResultHandler(_roResultHandler)
        , roRequestedITCs(_roRequestedITCs)
        , bTimeOutElapsed(_bTimeOutElapsed)
   {
   }

   virtual ID_CCA_GetDiagResult* clone() const
      {   return new ID_CCA_GetDiagResult(*this);  }

};




#endif /* ID_CCA_GETDIAGRESULT_H_ */
