/*************************************************************************
 *File          :  IDNotifyDiagResult.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  3/12/2012     Klotz       Initial version
 ************************************************************************/

#ifndef IDNOTIFYDIAGRESULT_H_
#define IDNOTIFYDIAGRESULT_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3DiagType.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifyDiagResult
 *
 *******************************************************************************/

class ID_NotifyDiagResult: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifyDiagResult(tenStream enErrorSite, tenErrorCode enErrorCode,tenErrorValue enErrorValue)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enErrorSite,enErrorCode,enErrorValue
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifyDiagResult(tenErrorSite enerrorsite, tenErrorCode enerrorcode, tenErrorValue enerrorvalue) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifyDiagResult), enErrorSite(enerrorsite), enErrorCode(enerrorcode), enErrorValue(enerrorvalue)
   {
   }


   tenErrorSite enErrorSite;
   tenErrorCode enErrorCode;
   tenErrorValue enErrorValue;


  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifyDiagResult *clone() const
   {
      return new ID_NotifyDiagResult(*this);
   }
};

#endif /* IDNOTIFYDIAGRESULT_H_ */
