/*************************************************************************
 *File          :  IDDiagLinearMode.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  04/02/2013     Gaidatzi-Lken       Initial version
 ************************************************************************/

#ifndef IDDIAGLINEARMODE_H_
#define IDDIAGLINEARMODE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/DiagLinearModeType.h"

/*******************************************************************************
 *
 * CLASS:ID_DiagLinearMode
 *
 *******************************************************************************/

class ID_DiagLinearMode: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_DiagLinearMode(tenLinearModePhase enLinearModePhase)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagLinearModePhase enDiagLinearModePhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_DiagLinearMode(tenDiagLinearModePhase endiaglinearmodephase) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_DiagLinearMode), enDiagLinearModePhase(endiaglinearmodephase)
    {
    }

  tenDiagLinearModePhase enDiagLinearModePhase;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_DiagLinearMode *clone() const
  {
    return new ID_DiagLinearMode(*this);
  }
};

#endif /* IDDIAGLINEARMODE_H_ */
