/*************************************************************************
 *File          :  IDDiagDefSet.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  21/12/2012     Gaidatzi-Lken       Initial version
 ************************************************************************/

#ifndef IDDIAGDEFSET_H_
#define IDDIAGDEFSET_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/DiagDefSetType.h"

/*******************************************************************************
 *
 * CLASS:ID_DiagDefSet
 *
 *******************************************************************************/

class ID_DiagDefSet: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_GetDiagResult(tenDiagDefSetType enDiagDefSetType, tenDiagDefSetPhase enDiagDefSetPhase)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagDefSetType enDiagDefSetType, tenDiagDefSetPhase enDiagDefSetPhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_DiagDefSet(tenDiagDefSetType endiagdefsettype, tenDiagDefSetPhase endiagdefsetphase) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_DiagDefSet), enDiagDefSetType(endiagdefsettype), enDiagDefSetPhase(endiagdefsetphase)
    {
    }

  tenDiagDefSetType enDiagDefSetType;
    tenDiagDefSetPhase enDiagDefSetPhase;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_DiagDefSet *clone() const
  {
    return new ID_DiagDefSet(*this);
  }
};

#endif /* IDDIAGDEFSET_H_ */
