/*************************************************************************
 *File          :  IDDiagControlLine.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  04/02/2013     Gaidatzi-Lken       Initial version
 ************************************************************************/

#ifndef IDDIAGCONTROLLINE_H_
#define IDDIAGCONTROLLINE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/DiagControlLineType.h"

/*******************************************************************************
 *
 * CLASS:ID_DiagControlLine
 *
 *******************************************************************************/

class ID_DiagControlLine: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_DiagControlLine(tenControlLinePhase enControlLinePhase)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: tenDiagControlLinePhase enDiagControlLinePhase
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_DiagControlLine(tenDiagControlLinePhase endiagcontrollinephase) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_DiagControlLine), enDiagControlLinePhase(endiagcontrollinephase)
    {
    }

  tenDiagControlLinePhase enDiagControlLinePhase;



  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_DiagControlLine *clone() const
  {
    return new ID_DiagControlLine(*this);
  }
};

#endif /* IDDIAGCONTROLLINE_H_ */
