/*************************************************************************
 *File          :  IDCarSetting.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  18/12/2012     Klotz       Initial version
 ************************************************************************/

#ifndef IDCARSETTING_H_
#define IDCARSETTING_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/TypeDefines/ADR3CarSettingType.h"

/*******************************************************************************
 *
 * CLASS:ID_CarSetting
 *
 *******************************************************************************/

class ID_CarSetting: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_CarSetting(tenCarSettingType enCarSettingType)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: enCarSettingType
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
  ID_CarSetting(tenCarSettingType encarsettingtype, tS16 s16value) :
    Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CarSetting), enCarSettingType(encarsettingtype), s16Value(s16value)
    {
    }


  tenCarSettingType enCarSettingType;
  tS16 s16Value;

  /*******************************************************************************
   *
   * FUNCTION:  *clone()
   *
   * DESCRIPTION :Clones the message
   *******************************************************************************/

  virtual ID_CarSetting *clone() const
  {
    return new ID_CarSetting(*this);
  }
};

#endif /* IDCARSETTING_H_ */
