/*************************************************************************
 *File          :  IDNotifySignalToneParameters.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Gerlinde Klotz       Initial version
 ************************************************************************/

#ifndef IDNOTIFYSIGNALTONEPARAMETERS_H_
#define IDNOTIFYSIGNALTONEPARAMETERS_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/MessageDataTypes/SignalToneParameterData.h"

/*******************************************************************************
 *
 * CLASS:ID_NotifySignalToneParameters
 *
 *******************************************************************************/

class ID_NotifySignalToneParameters: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifySignalToneParameters(SignalToneParameterData Values)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: SignalToneParameterData Values
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifySignalToneParameters(SignalToneParameterData Values) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifySignalToneParameters), values(Values)
   {
   }
   ;


   SignalToneParameterData values;


  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifySignalToneParameters *clone() const
   {
      return new ID_NotifySignalToneParameters(*this);
   }
};

#endif /* IDNOTIFYSIGNALTONEPARAMETERS_H_ */
