/*************************************************************************
 *File          :  IDNotifySignalTone.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : hag2hi
 *--------------------------------------------------------------------------
 Created by :  9/7/2012     Klotz       Initial version
 ************************************************************************/

#ifndef IDNOTIFYSIGNALTONE_H_
#define IDNOTIFYSIGNALTONE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"


/*******************************************************************************
 *
 * CLASS:ID_NotifySignalTone
 *
 *******************************************************************************/

class ID_NotifySignalTone: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  ID_NotifySignalTone(ten... enSignalToneType, ten... enSignalToneStatus)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: ubSignalToneType,ubSignalToneStatus
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   ID_NotifySignalTone(tU8 ubsignaltonetype, tU8 ubsignaltonestatus) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_NotifySignalTone), ubSignalToneType(ubsignaltonetype), ubSignalToneStatus(ubsignaltonestatus)
   {
   }
   ;

   tU8 ubSignalToneType;
   tU8 ubSignalToneStatus;

  /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
     *******************************************************************************/

   virtual ID_NotifySignalTone *clone() const
   {
      return new ID_NotifySignalTone(*this);
   }
};

#endif /* IDNOTIFYSIGNALTONE_H_ */
