
/************************************************************************FA*
 *File         :  IDChimeParameter.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  7/9/2012   7:13:02 PM   Anu Sebastian       Initial version
 ************************************************************************/
#ifndef IDCHIMEPARAMETER_H_
#define IDCHIMEPARAMETER_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "../../DataTypes/MessageDataTypes/ChimeData.h"

/*******************************************************************************
 *
 * CLASS:MSG_ChimeParameters
 *
 *******************************************************************************/

class MSG_ChimeParameters: public Message<PO_MessageConfig::enID>
{
public:
  /*******************************************************************************
   *
   * FUNCTION:  MSG_ChimeParameters(ChimeData Values)
   *
   * DESCRIPTION: Constructor
   *
   * PARAMETERS: Pulses,AttackTime,AttackTimeLog,AttackTimeLin,ReleaseTime,ReleaseTimeLog,ReleaseTimeLin,SignalToneAction
   *
   * RETURN TYPE:none
   *
   *******************************************************************************/
   MSG_ChimeParameters(ChimeData Values) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_ChimeParameters), values(Values)
   {
   }

   ChimeData values;


    /*******************************************************************************
  *
  * FUNCTION:  *clone()
  *
    * DESCRIPTION :Clones the message
    *******************************************************************************/

   virtual MSG_ChimeParameters* clone() const
   {
      return new MSG_ChimeParameters(*this);
   }
};

#endif /* IDChimeParameter_H_ */
