/************************************************************************FA*
 *File         :  IDCCAStartBeepFile.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2015 Robert Bosch GmbH, Hildesheim
 *Author            : Ranjit Katuri (RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  6/8/2015   7:13:02 PM   Ranjit Katuri       Initial version
 ************************************************************************/
#ifndef IDCCASTARTBEEPFILE_H_
#define IDCCASTARTBEEPFILE_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../../../PostOffice/Message.h"
#include "../../MessageConfig.h"
#include "Beep_defines.h"

/*******************************************************************************
 *
 * CLASS:ID_CCAStart_BeepFile
 *
 *******************************************************************************/

class ID_CCAStart_BeepFile: public Message<PO_MessageConfig::enID>
{
public:

   ID_CCAStart_BeepFile(std::string file_path,BeepFile_Config& rfConfig,tU32 u32Token) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_BeepFile), File_Path(file_path),oConfig(rfConfig),m_u32Token(u32Token)
   {
   }

   ID_CCAStart_BeepFile(const ID_CCAStart_BeepFile& pMsg) :
   Message<PO_MessageConfig::enID>(PO_MessageConfig::ID_CCAStart_BeepFile), File_Path(pMsg.File_Path),oConfig(pMsg.oConfig),m_u32Token(pMsg.m_u32Token)
   {}


   std::string File_Path;
   BeepFile_Config oConfig;

   tU32       m_u32Token;


   virtual ID_CCAStart_BeepFile* clone() const
   {
      return new ID_CCAStart_BeepFile(*this);
   }
};

#endif /* IDCCASTARTBEEPFILE_H_ */
