///////////////////////////////////////////////////////////
//  SourceTypeConverter.h
//  Implementation of the Class SourceTypeConverter
//  Created on:      06.12.2012
///////////////////////////////////////////////////////////

#if !defined(EA_8C0E02E0_47B4_43f7_A6B4_310FF9D461D2__INCLUDED_)
#define EA_8C0E02E0_47B4_43f7_A6B4_310FF9D461D2__INCLUDED_


#include "../TypeDefines/SourceDefines.h"
#include "../TypeDefines/PhoneTypes.h"
#include "../TypeDefines/EDTypeDefines.h"
#include "../TypeDefines/ADR3Source.h"
#include "../TypeDefines/ADR3SourceType.h"
#include "TypeConverterMap.h"
#include "TypeConverterMultiMap.h"


/**
 * This class (a) defines an Instance operation that lets clients access its unique instance, and (b) may be responsible for creating its own
 * unique instance.
 */
class SourceTypeConverter
{

public:
   tenInternalSource getIntSource(tenSourceType seachEntity);
   tenInternalSource getIntSource(midw_fi_tcl_e8_AudSource::tenType seachEntity);
   tenInternalSource getIntSource(midw_fi_tcl_e8_RouteNo::tenType seachEntity);
   tenInternalSource getIntSource(tenInternalPhoneTypes seachEntity);
   tenEDType getEdType(midw_fi_tcl_e8_AudSource::tenType searchEntity);
   tBool isPhoneTypeValid(tenInternalSource Source);
   tenSourceType GetSourceType(tenInternalSource SearchKey);
   midw_fi_tcl_e8_AudSource::tenType GetFIAudSource(tenInternalSource SearchKey);

   static SourceTypeConverter* getInstance();
   tVoid attachData ();

   // conversion functions from former AmpDeviceAudioRouteObserver and AudioSourceObserver
   static tenSource getPOSourceFromCCARoute(midw_fi_tcl_e8_RouteNo::tenType CCARoute);
   static bool getPOSourceTypeFromCCASource(midw_fi_tcl_e8_AudSource::tenType CCASourceType, tenSourceType& POSourcetype);

private:
   SourceTypeConverter();
   static SourceTypeConverter* pInstance;
   /**
    * Map of stream type from CCA define to ADR3 define
    */
   TypeConverterMap <tenSourceType, tenInternalSource> m_TypeConverterMapSourceTypeToIntSource;
   TypeConverterMultiMap <midw_fi_tcl_e8_AudSource::tenType, tenInternalSource> m_TypeConverterMapFIAudSourceToIntSource;
   TypeConverterMap <midw_fi_tcl_e8_RouteNo::tenType, tenInternalSource> m_TypeConverterMapFIRouteNoToIntSource;
   TypeConverterMap <tenInternalPhoneTypes, tenInternalSource> m_TypeConverterMapPhoneTypeToIntSource;
   TypeConverterMap <midw_fi_tcl_e8_AudSource::tenType, tenEDType> m_TypeConverterMapIntSrcToEDType;
};
#endif // !defined(EA_8C0E02E0_47B4_43f7_A6B4_310FF9D461D2__INCLUDED_)

