///////////////////////////////////////////////////////////
//  SourceTypeConverter.cpp
//  Implementation of the Class SourceTypeConverter
//  Created on:      06.12.2012
///////////////////////////////////////////////////////////

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>   // implicitly links generic <osal_if.h>

#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include <midw_fi_if.h>

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_FI_TYPES
#include <midw_ext_fi_if.h>


#include "SourceTypeConverter.h"

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/SourceTypeConverter.cpp.trc.h"
#endif

SourceTypeConverter* SourceTypeConverter::pInstance = NULL;

tVoid SourceTypeConverter::attachData()
{
#define EXT_SOURCE_TYPE_TO_INT_SOURCE
#define addData(a,b) m_TypeConverterMapSourceTypeToIntSource.attachEntity(a, b);
#include "SourceConverter.conf"
#undef addData
#undef EXT_SOURCE_TYPE_TO_INT_SOURCE

#define EXT_FI_AUD_SOURCE_TO_INT_SOURCE
#define addData(a,b) m_TypeConverterMapFIAudSourceToIntSource.attachEntity(a, b);
#include "SourceConverter.conf"
#undef addData
#undef EXT_FI_AUD_SOURCE_TO_INT_SOURCE

#define EXT_FI_ROUTENO_TO_INT_SOURCE
#define addData(a,b) m_TypeConverterMapFIRouteNoToIntSource.attachEntity(a, b);
#include "SourceConverter.conf"
   ETG_TRACE_USR4(("SourceTypeConverter::attachData: RouteNo exit\n"));
#undef addData
#undef EXT_FI_ROUTENO_TO_INT_SOURCE

#define EXT_FI_PHONE_TO_INT_SOURCE
#define addData(a,b) m_TypeConverterMapPhoneTypeToIntSource.attachEntity(a, b);
#include "SourceConverter.conf"
   ETG_TRACE_USR4(("SourceTypeConverter::attachData: Source exit\n"));
#undef addData
#undef EXT_FI_PHONE_TO_INT_SOURCE

#define EXT_FI_AUD_SOURCE_TO_EDTYPE
#define addData(a,b) m_TypeConverterMapIntSrcToEDType.attachEntity(a, b);
#include "SourceConverter.conf"
   ETG_TRACE_USR4(("SourceTypeConverter::attachData: EDType exit\n"));
#undef addData
#undef EXT_FI_AUD_SOURCE_TO_EDTYPE
}


/*******************************************************************************
 *
 *  conversion functions from former
 *      AmpDeviceAudioRouteObserver and
 *      AudioSourceObserver
 *
 *******************************************************************************/


/* static */  bool SourceTypeConverter::getPOSourceTypeFromCCASource(midw_fi_tcl_e8_AudSource::tenType CCASourceType, tenSourceType& POSourceType)
{
   // static mapping tables
   struct CCASrcToPOSrcType
   {
      midw_fi_tcl_e8_AudSource::tenType CCASrcType;
      tenSourceType POSrcType;
   };
   const CCASrcToPOSrcType CCASrcToPOSrcTypeMap[]
    = {
         #define AUDIO_SOURCE_CCASRC_TO_POSRCTYPE_MAP
         #define AudioSourceType(a,b) {a,b},
         #include "SourceConverter.conf"
         #undef AudioSourceType
         #undef AUDIO_SOURCE_CCASRC_TO_POSRCTYPE_MAP
   };
   const size_t CCASrcToPOSrcTypeMapSize = sizeof(CCASrcToPOSrcTypeMap) / sizeof(CCASrcToPOSrcType);

   // scan table for matching entry
   for (size_t i = 0; i < CCASrcToPOSrcTypeMapSize; ++i)
      if (CCASrcToPOSrcTypeMap[i].CCASrcType == CCASourceType)
      {
         POSourceType = CCASrcToPOSrcTypeMap[i].POSrcType;
         ETG_TRACE_USR4(("SourceTypeConverter::getPOSourceTypeFromCCASource() found POSourceType: %d for %d from %u-sized list"
            , ETG_CENUM(tenSourceType, POSourceType)
            , ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, CCASourceType)
            , CCASrcToPOSrcTypeMapSize));
         return true;
      }

   // not found
   ETG_TRACE_FATAL(("SourceTypeConverter::getPOSourceTypeFromCCASource() no match found for %d in %u-sized list"
      , ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, CCASourceType)
      , CCASrcToPOSrcTypeMapSize));
   return false;
}

// -----------------------------------------------------------------------------

/* static */ tenSource SourceTypeConverter :: getPOSourceFromCCARoute (midw_fi_tcl_e8_RouteNo::tenType CCARoute)
{
   // mapping table
   struct CCARouteToPOSrc
   {
      midw_fi_tcl_e8_RouteNo::tenType CCARoute;
      tenSource POSrc;
   };
   static const CCARouteToPOSrc  CCARouteToPOSrcMap[]
    = {
         #define AUDIO_SOURCE_CCAROUTE_TO_POSRC_MAP
         #define AudioSource(a,b)  {a,b},
         #include "SourceConverter.conf"
         #undef AudioSource
         #undef AUDIO_SOURCE_CCAROUTE_TO_POSRC_MAP
   };
   static const size_t CCARouteToPOSrcMapSize = sizeof(CCARouteToPOSrcMap) / sizeof(CCARouteToPOSrc);

   // search for matching entry
   for (size_t i = 0; i < CCARouteToPOSrcMapSize; ++i)
      if (CCARouteToPOSrcMap[i].CCARoute == CCARoute)
      {
         ETG_TRACE_USR4(("SourceTypeConverter::getPOSourceFromCCARoute: return %d for %d from %u entries"
             , ETG_CENUM(tenSource, CCARouteToPOSrcMap[i].POSrc)
             , ETG_CENUM (midw_fi_tcl_e8_RouteNo::tenType, CCARoute)
             , CCARouteToPOSrcMapSize))
         return CCARouteToPOSrcMap[i].POSrc;
      }

   // not found
   ETG_TRACE_FATAL(("SourceTypeConverter::getPOSourceFromCCARoute: no source found for %d from %u entries"
      , ETG_CENUM (midw_fi_tcl_e8_RouteNo::tenType, CCARoute)
      , CCARouteToPOSrcMapSize));
   return EN_AUDIO_SOURCE_NOSRC;
}

// -----------------------------------------------------------------------------

SourceTypeConverter::SourceTypeConverter()
{

}
tenInternalSource SourceTypeConverter::getIntSource(tenSourceType seachEntity)
{
   tenInternalSource OutData = AUD_INT_SRC_UNDEFINED;
   OutData = m_TypeConverterMapSourceTypeToIntSource.getSecond(seachEntity);
   return (OutData);
}

tenInternalSource SourceTypeConverter::getIntSource(midw_fi_tcl_e8_AudSource::tenType seachEntity)
{
   tenInternalSource OutData = AUD_INT_SRC_UNDEFINED;
   OutData = m_TypeConverterMapFIAudSourceToIntSource.getSecond(seachEntity);

   return (OutData);
}

tenInternalSource SourceTypeConverter::getIntSource(midw_fi_tcl_e8_RouteNo::tenType seachEntity)
{
   tenInternalSource OutData = AUD_INT_SRC_UNDEFINED;
   OutData = m_TypeConverterMapFIRouteNoToIntSource.getSecond(seachEntity);

   return (OutData);
}

tenInternalSource SourceTypeConverter::getIntSource(tenInternalPhoneTypes seachEntity)
{
   tenInternalSource OutData = AUD_INT_SRC_UNDEFINED;

   if (TRUE == m_TypeConverterMapPhoneTypeToIntSource.isIndexTypeAttached(seachEntity))
   {
      OutData = m_TypeConverterMapPhoneTypeToIntSource.getSecond(seachEntity);
      ETG_TRACE_USR4(("SourceTypeConverter::getIntSource: source %d found for search entity %d\n",
                  ETG_CENUM (tenInternalSource,OutData),
                  ETG_CENUM (tenInternalPhoneTypes, seachEntity)));
   }
   else
      ETG_TRACE_USR4(("SourceTypeConverter::getIntSource: no source found for %d\n",
                  ETG_CENUM (tenInternalPhoneTypes, seachEntity)));

   return (OutData);
}

tenSourceType SourceTypeConverter::GetSourceType(tenInternalSource SearchKey)
{
   tenSourceType OutData = EN_AUDIO_SOURCE_SOURCETYPE_NOSOURCE;

   OutData = m_TypeConverterMapSourceTypeToIntSource.getKey(SearchKey);

   return (OutData);
}

tBool SourceTypeConverter::isPhoneTypeValid(tenInternalSource Source)
{
   ETG_TRACE_USR4(("SourceTypeConverter::isPhoneTypeValid: enter: incoming source %d\n",
               ETG_CENUM (tenInternalSource, Source)));

   tenInternalPhoneTypes FISource = m_TypeConverterMapPhoneTypeToIntSource.getKey(Source);
   tBool EntityFound = m_TypeConverterMapPhoneTypeToIntSource.isIndexTypeAttached(FISource);

   ETG_TRACE_USR4(("SourceTypeConverter::isPhoneTypeValid: enter: Entity found: %d, found FISource: %d\n",
               EntityFound, ETG_CENUM (tenInternalPhoneTypes, FISource)));

   if ((TRUE == EntityFound) && (AUD_INT_SRC_UNDEFINED != Source))
   {
      ETG_TRACE_USR4(("SourceTypeConverter::isPhoneTypeValid: valid\n"));
      return (TRUE);
   }

   else
   {
      ETG_TRACE_USR4(("SourceTypeConverter::isPhoneTypeValid: invalid\n"));
      return (FALSE);
   }
}

midw_fi_tcl_e8_AudSource::tenType SourceTypeConverter::GetFIAudSource(tenInternalSource SearchKey)
{
   midw_fi_tcl_e8_AudSource::tenType OutData = midw_fi_tcl_e8_AudSource::FI_EN_NONE;

   OutData = m_TypeConverterMapFIAudSourceToIntSource.getKey(SearchKey);

   return (OutData);
}

tenEDType SourceTypeConverter::getEdType(midw_fi_tcl_e8_AudSource::tenType searchEntity)
{
  tenEDType Outdata = EN_ED_NO_GAIN;
  Outdata = m_TypeConverterMapIntSrcToEDType.getSecond(searchEntity);
  return Outdata;
}
SourceTypeConverter* SourceTypeConverter::getInstance()
{
   if (OSAL_NULL == SourceTypeConverter::pInstance)
   {
      SourceTypeConverter::pInstance = new SourceTypeConverter;
      pInstance->attachData();
   }
   return (SourceTypeConverter::pInstance);
}
