/**
 * Volume.h
 *
 *  Created on: Jul 21, 2012
 *      Author: mor2hi
 */

#ifndef VOLUME_SOURCE_DATA_H_
#define VOLUME_SOURCE_DATA_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "CCA/FI_Message/FI_Includes.h"

#include "../TypeDefines/SourceDefines.h"
#include "../TypeDefines/ADR3StreamType.h"
#include "../ResourceType.h"
#include "../VolumeType.h"

class VolumeSourceData {
public:
   ResourceType m_Resource;
   midw_fi_tcl_e8_AudioChannel::tenType m_Channel;
   tenInternalSource m_Source;
   /**
    * SourceType is used to give addtional source infomation.
    * This is used for phone at the moment. The phone component is sending a specific phone type within a separate CCA message.
    * This information is stored here as a source.
    */
   tenInternalSource m_Source_Type;
   tU8 m_ClientSource;

public:
   VolumeSourceData();
   VolumeSourceData(const VolumeSourceData& DataToBeCopied);
   virtual ~VolumeSourceData();

   tVoid vSetToDefault();
   tVoid printData () const;

   VolumeSourceData& operator=(const VolumeSourceData& data);
private:
   tVoid copyData(const VolumeSourceData& data);
};

#endif
