/**
 * VolumeOffsetData.cpp
 *
 *  Created on: Nov 15, 2012
 *      Author: hag2hi
 */

#include "VolumeOffsetData.h"
#include "../../../util/Macro.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#include "trcGenProj/Header/VolumeOffsetData.cpp.trc.h"
#endif

VolumeOffsetData::VolumeOffsetData()
{
     m_enStream    = EN_AUDIO_SOURCE_STREAM_DEFAULT;
     s16Offset_LF  = 0x00;
     s16Offset_RF  = 0x00;
     s16Offset_LR  = 0x00;
     s16Offset_RR  = 0x00;
     s16Offset_CE  = 0x00;
     s16Offset_SUB = 0x00;
     u16RampLin    = 0x00;
     u16RampdB     = 0x00;

}

VolumeOffsetData::VolumeOffsetData(const VolumeOffsetData& DataToBeCopied)
{
   copyData(DataToBeCopied);
}

VolumeOffsetData::~VolumeOffsetData()
{
   // TODO Auto-generated destructor stub
}

tVoid VolumeOffsetData::vSetToDefault()const
{
}

VolumeOffsetData& VolumeOffsetData::operator=(const VolumeOffsetData& rhs)
{
   // protection again copy on itself
   if( &rhs == this)
   {
      ETG_TRACE_USR4(("VolumeOffsetData: self compare!"));
      NORMAL_M_ASSERT_ALWAYS();
   }

   copyData(rhs);
   return (*this);
}

tVoid VolumeOffsetData::copyData(const VolumeOffsetData& data)
{
   m_enStream    = data.m_enStream;
   s16Offset_LF  = data.s16Offset_LF;
   s16Offset_RF  = data.s16Offset_RF;
   s16Offset_LR  = data.s16Offset_LR;
   s16Offset_RR  = data.s16Offset_RR;
   s16Offset_CE  = data.s16Offset_CE;
   s16Offset_SUB = data.s16Offset_SUB;
   u16RampLin    = data.u16RampLin;
   u16RampdB     = data.u16RampdB;
}
