/**
 * Volume.h
 *
 *  Created on: Jul 21, 2012
 *      Author: mor2hi
 */

#ifndef VOLUME_H_
#define VOLUME_H_
#include "../ResourceType.h"
#include "../VolumeType.h"
#include "../TypeDefines/VolumeModeDefines.h"

#include "CCA/FI_Message/FI_Includes.h"

class VolumeData {
public:
   ResourceType m_Resource;
   midw_fi_tcl_e8_AudioChannel::tenType m_Channel;
   VolumeType m_VolumeType;
   tU8 m_Volume;
   tS16 m_VolumeGain;
   tenVolumeType m_VolumeGroup;

public:
   VolumeData();
   VolumeData(const VolumeData& DataToBeCopied);
   virtual ~VolumeData();
   /*
   bool operator==(VolumeData const& A, VolumeData const& B)
      {
      return (
      A.getResource() == B.getResource()
      &&
      A.getVolume() == B.getVolume()
      &&
      A.getVolumeType() == B.getVolumeType()
            );
      }
      */
   VolumeData& operator=(const VolumeData& rhs);

   virtual tVoid vSetToDefault();
   tU8 getVolume ()const;
   midw_fi_tcl_e8_AudioVolumeType::tenType getVolumeType ()const;
   midw_fi_tcl_e8_ResourceNo::tenType getResource ()const;
   tS16 getVolumeGain()const;

   tVoid setVolume (tU8 Volume);
   tVoid setVolumeType (midw_fi_tcl_e8_AudioVolumeType::tenType);
   tVoid setResource (midw_fi_tcl_e8_ResourceNo::tenType Resource);
   tVoid setVolumeGain(tS16 Gain);
   tVoid printData () const;

private:
   tVoid copyData(const VolumeData& data);

};

#endif /* VOLUME_H_ */
