/*
 * ApplicationTriggerData.cpp
 *
 *  Created on: 30.04.2013
 *      Author: mor2hi
 */

#include "ApplicationTriggerData.h"
#include "../../../util/Macro.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_APPLICATION
#include "trcGenProj/Header/ApplicationTriggerData.cpp.trc.h"
#endif

tVoid ApplicationTriggerData::vSetToDefault()
{
   m_Trigger = AUD_APP_TRIGGER_DEFAULT;
}

ApplicationTriggerData::ApplicationTriggerData()
{
   vSetToDefault();

}

ApplicationTriggerData::ApplicationTriggerData(const ApplicationTriggerData* DataToBeCopied)
{
   m_Trigger = AUD_APP_TRIGGER_DEFAULT;

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(DataToBeCopied);
   m_Trigger = DataToBeCopied->m_Trigger;
}

ApplicationTriggerData::~ApplicationTriggerData()
{
   // TODO Auto-generated destructor stub
}

tVoid ApplicationTriggerData::printData()
{
   ETG_TRACE_USR4(("ApplicationTriggerData: Data: Trigger: %d\n",
               ETG_CENUM(tenApplicationTrigger, m_Trigger)
         ));
}
