//
// CCA_Msg.cpp
//
//  Created on: 01.12.2011
//      Author: mor2hi
//

#include "aud_CCAMsg.h"

#include "Macro.h"
#include "../../fc_audiomanager_main.h"
class fc_audiomanager_tclApp;

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     aud_CCAMsg::vSendError
 *
 *DESCRIPTION:  Sends an error - message
 *
 *PARAMETER:    data for addressing the message
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *15.04.05 aca2hi
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/ //
tVoid aud_CCAMsg::vSendError(const amt_tclServiceData* const poMessage, T_e8_Audio_CCAError ErrorCode)
{
   fc_audiomanager_tclApp* poMain = NULL;
   poMain = fc_audiomanager_tclApp::theServer();

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMain);
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

   // Form a generic error message
   gm_tclU8Message oErrorMsg(poMessage->u16GetTargetAppID(), poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(),
         poMessage->u16GetCmdCounter(), poMessage->u16GetServiceID(), poMessage->u16GetFunctionID(), AMT_C_U8_CCAMSG_OPCODE_ERROR);
   // Set the error code
   oErrorMsg.vSetByte((tU8) ErrorCode);

   // Check if there is any error
   if (poMain->enPostMessage(&oErrorMsg) != AIL_EN_N_NO_ERROR)
   {
      // Error in sending the message
      if (!oErrorMsg.bDelete())
      {
         // Error in deleting the message
      }
   }
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     aud_CCAMsg::vSendMessage
 *
 *DESCRIPTION:  Forms & sends CCA messages
 *
 *PARAMETER:
 *
 *RETURNVALUE:  bool: true -> sending was successful
 *
 *HISTORY:
 *04.04.06 mor2hi
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tBool aud_CCAMsg::vSendMessage(fi_tclVisitorMessage* pResultMsg, tU16 u16SourceApp, tU16 u16TargetAppID, tU8 u8StreamType, tU16 u16StreamCounter,
      tU16 u16RegID, tU16 u16CmdCounter, tU16 u16ServiceID, tU16 u16FktID, tU8 u8Opcode)const
{
   tBool bFuncReturn = FALSE;
   fc_audiomanager_tclApp* poMain = NULL;
   poMain = fc_audiomanager_tclApp::theServer();

   AUD_POINTER_CHECK_CALL(poMain);
   AUD_POINTER_CHECK_CALL(pResultMsg);

   // initialise result message
   pResultMsg->vInitServiceData(u16SourceApp, // source
         u16TargetAppID, // Target
         u8StreamType, // StreamType
         (tU8) u16StreamCounter, // StreamCounter
         u16RegID, // RegisterID
         u16CmdCounter, // nCmdCounter,
         u16ServiceID, // nServiceID,
         u16FktID, // function ID
         u8Opcode);

   ail_tenCommunicationError enResult = poMain->enPostMessage(pResultMsg);
   if (AIL_EN_N_NO_ERROR != enResult)
   {

      //don�t throw an assert, this is not an error in any case
      bFuncReturn = FALSE;

      // delete message
      pResultMsg->bDelete();
   }
   else
   {
      bFuncReturn = TRUE;
   }

   return (bFuncReturn);
}
