///////////////////////////////////////////////////////////
//  PowerStateHandler.cpp
//  Implementation of the Class PowerStateHandler
//  Created on:      20-Jul-2012 12:51:56
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#include "PowerStateHandler.h"
#include "../../../InternalComponentCommunication/Messages/power/ID_ApplicationStatus.h"
#include "InternalCommunicationAdapter.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../../fc_audiomanager_trace.h"
#include "../../../fc_audiomanager_trace_macros.h"
#include "../../../fc_audiomanager_main.h"
#include "../../../fc_audiomanager_service_Audio_Function.h"
#include "../../../InternalComponentCommunication/DataTypes/TypeConverter/ApplicationStateTypeConverter.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/PowerStateHandler.cpp.trc.h"
#endif
tVoid PowerStateHandler::addObserver()const
{
   ETG_TRACE_USR4(("PowerStateHandler: addObserver\n"));
}


PowerStateHandler::PowerStateHandler(fc_audiomanager_tclApp* _poMainAppl, fc_audiomanager_tclService_Audio_Function* poService) :
      m_pCCAMainApplication(_poMainAppl), m_pCCAServiceFunc(poService)
{
   addObserver();
}

tVoid PowerStateHandler::deliverMessage(ApplicationStateData *pData)const
{
   ETG_TRACE_USR1(("PowerStateHandler: deliverMessage"));
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pData);
   pData->printData();
   ID_ApplicationStatus ApplicationStatus(*pData);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ApplicationStatus);
}

tVoid PowerStateHandler::handleNewApplicationState(tU32 OldState, tU32 State)const
{
   ApplicationStateTypeConverter *pAppStateConverter = ApplicationStateTypeConverter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAppStateConverter);

   ApplicationStateData sendData;
   sendData.m_State = pAppStateConverter->getInternalUsedTypeForApplicationState(State);
   deliverMessage(&sendData);
   (tVoid)OldState;
}

tVoid PowerStateHandler::handleNewVoltageState(tU32 State)const
{
   ApplicationStateTypeConverter *pAppStateConverter = ApplicationStateTypeConverter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAppStateConverter);

   ApplicationStateData sendData;
   sendData.m_State = pAppStateConverter->getInternalUsedTypeForVoltageState(State);
   deliverMessage(&sendData);
}

tVoid PowerStateHandler::handleNewCoproState(tU32 State)const
{
   ApplicationStateTypeConverter *pAppStateConverter = ApplicationStateTypeConverter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAppStateConverter);

   ApplicationStateData sendData;
   sendData.m_State = pAppStateConverter->getInternalUsedTypeForCoproState(State);
   deliverMessage(&sendData);
}

tVoid PowerStateHandler::deliverTTFisMessage(tU32 size, tPCUChar pData)const
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pData);
   ETG_TRACE_USR4(("Incoming TTFis Command: SetPowerState: Data=0x%02x",ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pData)));

   ApplicationStateTypeConverter *pAppStateConverter = ApplicationStateTypeConverter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAppStateConverter);

   ApplicationStateData Data;
   Data.m_State =  (tenApplicationStates) pData[2];

   deliverMessage(&Data);
}

