/**
 * @file EngineSoundHandlerIVI.h
 * @brief Implementation of interface EseGeneratorIf for premium II external amplifier
 * @author prm4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ESEGENERATOREXTAMP_H_
#define ESEGENERATOREXTAMP_H_

#include "EseGeneratorIf.h"

class EseGeneratorExtAmp : public EseGeneratorIf, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   EseGeneratorExtAmp();
   ~EseGeneratorExtAmp();

   tBool bStartUp(tU8 u8EseSoundType, tU8 u8EseVolume, tU8 u8RSoundOnOff, tU8 u8RSoundType, tU8 u8RSoundVolume);

   tVoid vSendESEOnOff(tBool bOn);
   tVoid vRequestESEOnOffStatus();
   tVoid vSendESESoundType(tU8 u8SoundType, tU8 u8Volume);
   tVoid vSendESEVolume(tU8 u8Volume);
   tVoid vSendRSoundType(tU8 u8SoundType, tU8 u8Volume);
   tVoid vSendRSoundVolume(tU8 u8Volume);
   tVoid vRequestESEVolumeStatus();
   tVoid vLoadESEParameter(tU8* pu8Data, tU32 u32Size);
   tVoid vDataCon();
   void MessageNotification(PO_MessageConfig::enID MsgId);
private:
   tU8 m_u8EseSoundTypeReq;
   tU8 m_u8EseSoundVolumeReq;

   tVoid vSendSettingMessage(tU8 u8SettingType, tS16 s16Value);
};
#endif //ESEGENERATOREXTAMP_H_
