/**
 * @file EseFileContainerIVI.cpp
 * @author prm4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup
 * @{
 */

#include <string.h>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ENGINESOUND
#include "trcGenProj/Header/EseFileContainerIVI.cpp.trc.h"
#endif
#include "util/Macro.h"
#include "EseFileContainerIVI.h"

#define ESE_FILE_SIZE(_fileId) \
   ( \
      (_fileId == 1) ? ESE_FILEID1_SIZE:\
      (_fileId == 2) ? ESE_FILEID2_SIZE:\
      (_fileId == 3) ? ESE_FILEID3_SIZE:\
      (_fileId == 4) ? ESE_FILEID4_SIZE:\
      (_fileId == 5) ? ESE_FILEID5_SIZE:\
      0 \
   )

#define SERIALIZE_ESEFILEDATA(eseFiledata, datamember, datasize, totallen) \
                              memcpy(eseFiledata,datamember,datasize); \
                              eseFiledata = eseFiledata + datasize;  \
                              totallen    = totallen + datasize;

#define INFLATE_AND_SERIALIZE_ESEFILEDATA(eseFiledata, datamember, datasize, inflateToSize, totallen) \
                              memcpy(eseFiledata,datamember,datasize); \
                              eseFiledata += inflateToSize;  \
                              totallen    += inflateToSize;

EseFileContainerIVI::EseFileContainerIVI()
{
}

EseFileContainerIVI::~EseFileContainerIVI()
{
}

tU32 EseFileContainerIVI::u32GetDataSize(tU8 fileId) const
{
   if (fileId < 1 || fileId > ENGINE_SOUND_NUMBER_OF_ESE_FILES)
   {
      ETG_TRACE_FATAL(("File-ID %i out of bounds (1..%i)", fileId, ENGINE_SOUND_NUMBER_OF_ESE_FILES));
   }
   return ESE_FILE_SIZE(fileId);
}

tU32 EseFileContainerIVI::u32GetEseFileData(tU8 *pData, tU32 u32datalen, tU8 u8FileId, tU8* pEseFileData)
{
  if(ESE_PARAM_SIZE_MEX == u32datalen)
      return u32GetEseFileDataForMex(pData,u8FileId,pEseFileData);

   else if(ESE_PARAM_SIZE_RSOUND == u32datalen)
      return u32GetEseFileDataForRSound(pData,u8FileId,pEseFileData);

   return 0;
}

tU32 EseFileContainerIVI::u32GetEseFileDataForMex(tU8 *pData, tU8 u8FileId, tU8* pEseFileData)
{
  EseDataLayout_mex* pEseLayout = reinterpret_cast<EseDataLayout_mex*>((tVoid*)pData);

  if((NULL == pEseFileData) || (NULL == pEseLayout))
      return 0;

   tU32 u32Len = 0;

  if(1 == u8FileId)
  {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_aVehAxis,(tU32)sizeof(pEseLayout->EseDes_aVehAxis),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_nEngAxis,(tU32)sizeof(pEseLayout->EseDes_nEngAxis),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAccrPercAxis,(tU32)sizeof(pEseLayout->EseDes_ratAccrPercAxis),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpAVeh,(tU32)sizeof(pEseLayout->EseDes_ratAmpAVeh),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpVVeh,(tU32)sizeof(pEseLayout->EseDes_ratAmpVVeh),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_vVehAxis,(tU32)sizeof(pEseLayout->EseDes_vVehAxis),u32Len)
  }

   else if(2 == u8FileId)
  {
      tU8 au8BoxData[1800];

      INFLATE_AND_SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratOffsHrmcAccel,sizeof(pEseLayout->EseDes_ratOffsHrmcAccel),50,u32Len)
      INFLATE_AND_SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_agPhaIninAccel,sizeof(pEseLayout->EseDes_agPhaIninAccel),50,u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpAccrAccel,(tU32)sizeof(pEseLayout->EseDes_ratAmpAccrAccel),u32Len)

      //EseDes_ratAmpNEngAccel is a Matlab Box data i.e. It is a 2 dimensional data
      //For MEX sound It has 71 rows, as indicated by the vecRPM parameter and 15 columns as given by vecRang_g
      //For RSound    It has 71 rows, as indicated by the vecRPM parameter and 25 columns as given by vecRang_g
      //ADR3 always expects this data with 71*25 dimension
      //Hence the box data to be inflated to 25 columns here for a MEX sound. Additional columns are filled with 0x00
      //Since the data in total is 3550 (71*25*2bytes) bytes, it is transmitted as two seperate ESE-Files
      //ESE-FileID2 contains the first 1740 bytes
      //Hence here we expand the first 35*15 matrix (rows 1-35) in to a 35*25 matrix that would result in 1750 bytes
      //But as per the interface, only 1740 bytes can be transmitted in FileID2, remaining 10 bytes is transmitted along with FileID2

      vInflateBoxDataColumns(pEseLayout->EseDes_ratAmpNEngAccel,au8BoxData,35,15,25);
      SERIALIZE_ESEFILEDATA(pEseFileData,au8BoxData,1740,u32Len)
  }

   else if(3 == u8FileId)
   {
      tU8 au8BoxData[1900];

      //First 35*15 matrix is expanded for FileID2. But last 10 bytes (out of 50 bytes for row 35) could not be -
      //transmitted as part of FileID2 due interface size limitation.
      //Hence here we inflate the second part also including row 35
      //But the first 40 bytes of inflated data is already send in FileID2,hence data after that is packed here to FileID3

      vInflateBoxDataColumns(&pEseLayout->EseDes_ratAmpNEngAccel[1020],au8BoxData,37,15,25);
      SERIALIZE_ESEFILEDATA(pEseFileData,&au8BoxData[40],1810,u32Len)

      INFLATE_AND_SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratHrmcAccel,sizeof(pEseLayout->EseDes_ratHrmcAccel),50,u32Len)

   }

   else if(4 == u8FileId)
   {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratOffsHrmcDecel,(tU32)sizeof(pEseLayout->EseDes_ratOffsHrmcDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_agPhaIninDecel,(tU32)sizeof(pEseLayout->EseDes_agPhaIninDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpAccrDecel,(tU32)sizeof(pEseLayout->EseDes_ratAmpAccrDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpNEngDecel,(tU32)sizeof(pEseLayout->EseDes_ratAmpNEngDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratHrmcDecel,(tU32)sizeof(pEseLayout->EseDes_ratHrmcDecel),u32Len)
   }

   else if(5 == u8FileId)
   {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAudioGain,(tU32)sizeof(pEseLayout->EseDes_ratAudioGain),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_tiAudioDly,(tU32)sizeof(pEseLayout->EseDes_tiAudioDly),u32Len)
   }

   return u32Len;
}

tU32 EseFileContainerIVI::u32GetEseFileDataForRSound(tU8 *pData, tU8 u8FileId, tU8* pEseFileData)
{
   EseDataLayout_rsound* pEseLayout = reinterpret_cast<EseDataLayout_rsound*>((tVoid*)pData);

   if((NULL == pEseFileData) || (NULL == pEseLayout))
      return 0;

   tU32 u32Len = 0;

  if(1 == u8FileId)
  {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_aVehAxis,(tU32)sizeof(pEseLayout->EseDes_aVehAxis),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_nEngAxis,(tU32)sizeof(pEseLayout->EseDes_nEngAxis),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAccrPercAxis,(tU32)sizeof(pEseLayout->EseDes_ratAccrPercAxis),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpAVeh,(tU32)sizeof(pEseLayout->EseDes_ratAmpAVeh),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpVVeh,(tU32)sizeof(pEseLayout->EseDes_ratAmpVVeh),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_vVehAxis,(tU32)sizeof(pEseLayout->EseDes_vVehAxis),u32Len)
  }

   else if(2 == u8FileId)
  {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratOffsHrmcAccel,(tU32)sizeof(pEseLayout->EseDes_ratOffsHrmcAccel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_agPhaIninAccel,(tU32)sizeof(pEseLayout->EseDes_agPhaIninAccel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpAccrAccel,(tU32)sizeof(pEseLayout->EseDes_ratAmpAccrAccel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpNEngAccel_1,(tU32)sizeof(pEseLayout->EseDes_ratAmpNEngAccel_1),u32Len)
  }

   else if(3 == u8FileId)
   {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpNEngAccel_2,(tU32)sizeof(pEseLayout->EseDes_ratAmpNEngAccel_2),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratHrmcAccel,(tU32)sizeof(pEseLayout->EseDes_ratHrmcAccel),u32Len)
   }

   else if(4 == u8FileId)
   {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratOffsHrmcDecel,(tU32)sizeof(pEseLayout->EseDes_ratOffsHrmcDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_agPhaIninDecel,(tU32)sizeof(pEseLayout->EseDes_agPhaIninDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpAccrDecel,(tU32)sizeof(pEseLayout->EseDes_ratAmpAccrDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAmpNEngDecel,(tU32)sizeof(pEseLayout->EseDes_ratAmpNEngDecel),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratHrmcDecel,(tU32)sizeof(pEseLayout->EseDes_ratHrmcDecel),u32Len)
   }

   else if(5 == u8FileId)
   {
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_ratAudioGain,(tU32)sizeof(pEseLayout->EseDes_ratAudioGain),u32Len)
      SERIALIZE_ESEFILEDATA(pEseFileData,pEseLayout->EseDes_tiAudioDly,(tU32)sizeof(pEseLayout->EseDes_tiAudioDly),u32Len)
   }

   return u32Len;
}

tVoid EseFileContainerIVI::vInflateBoxDataColumns(const tU8 *pData, tU8* pExpandedData, tU8 u8InRows, tU8 u8InCols, tU8 u8OutCols)
{
   memset(pExpandedData,0,u8InRows*u8OutCols*2);

   for(tU8 u8Iter = 0; u8Iter < u8InRows; u8Iter++)
   {
      memcpy(pExpandedData,&pData[u8Iter*u8InCols*2],u8InCols*2);
      pExpandedData += u8OutCols*2;
   }
}
