/**
 * @file EngineSoundMsgQueue.h
 * @author CM-AI wie1hi
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ENGINESOUNDMSGQUEUE_H_
#define ENGINESOUNDMSGQUEUE_H_

#include <queue>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "EngineSoundMessage.h"
#include "aud_sinkmanager/vd_adr3/vd_adr3Message_Data.h"
#include "LoopBack/aud_loopback_if.h"

class EngineSoundMsgQueue
{
public:
   EngineSoundMsgQueue();
   ~EngineSoundMsgQueue();

   void vQueueEngineSoundMessage(EngineSoundMessage eseMsg);

   void vAdrReady();
   void vEnableQueue();
   /************timer functionalities********************/
   void vCreateEngineSoundSetTimer(tVoid);
   void vStartEngineSoundSetTimer(tU16 uwTimeMs);
   static tVoid vEngineSoundTimerCallback(tVoid* pArg);
   OSAL_tTimerHandle m_hESETimer;
   /*****************************************************/
private:
   void vProcessQueue();
   std::queue<EngineSoundMessage> m_EngineSoundMessageQueue;
   bool m_bProcessingMessages;
   bool m_bQueueEnabled;
   aud_async_call_handler*  m_asynccall;
   static EngineSoundMsgQueue* m_pothisInstance;
};

#endif /* ENGINESOUNDMSGQUEUE_H_ */
