/**
 * @file EngineSoundMsgQueue.cpp
 * @author CM-AI wie1hi
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ENGINESOUND
#include "trcGenProj/Header/EngineSoundMsgQueue.cpp.trc.h"
#endif

#include "EngineSoundMsgQueue.h"
#include "vd_adr3Msg_If.h"

#define ESE_SET_TIMER_INTERVAL 300//300ms timer for ESE OnOff

EngineSoundMsgQueue *EngineSoundMsgQueue::m_pothisInstance = NULL;

EngineSoundMsgQueue::EngineSoundMsgQueue()
:m_bProcessingMessages(false), m_bQueueEnabled(false)
{
  m_hESETimer = OSAL_C_INVALID_HANDLE;
  vCreateEngineSoundSetTimer();
    m_pothisInstance = this;
    m_asynccall = fc_audiomanager_tclApp::theServer()->poAsyncCall();
}

EngineSoundMsgQueue::~EngineSoundMsgQueue()
{
    m_pothisInstance = NULL;
    m_asynccall = NULL;
    if( m_hESETimer != OSAL_C_INVALID_HANDLE)
    {
      tS32 s32OsalError = OSAL_s32TimerSetTime( m_hESETimer, 0, 0 );//stop the timer
      s32OsalError = OSAL_s32TimerDelete(m_hESETimer);

      NORMAL_M_ASSERT( s32OsalError == OSAL_OK);

      m_hESETimer = OSAL_C_INVALID_HANDLE;
    }
}

void EngineSoundMsgQueue::vQueueEngineSoundMessage(EngineSoundMessage eseMsg)
{
   ETG_TRACE_USR4(("EngineSoundMsgQueue::vQueueEngineSoundMessage(FktID:0x%x) entered.", eseMsg.m_u16FktId));

   m_EngineSoundMessageQueue.push(eseMsg);

   if (!m_bProcessingMessages)
   {
      vProcessQueue();
   }
}

void EngineSoundMsgQueue::vProcessQueue()
{
   if (!m_bQueueEnabled)
   {
      ETG_TRACE_USR4(("EngineSoundMsgQueue::vProcessQueue() not executed. Queue not enabled."));
      return;
   }

   if (!m_EngineSoundMessageQueue.empty())
   {
      m_bProcessingMessages = true;
      ETG_TRACE_USR4(("EngineSoundMessageQueue size = %i. Processing next element.", m_EngineSoundMessageQueue.size()));
      EngineSoundMessage eseMsg = m_EngineSoundMessageQueue.front();
      m_EngineSoundMessageQueue.pop();

      ETG_TRACE_USR2(("EngineSoundADR::SendToADR(FktID:%i, DataLen:%i) entered.", eseMsg.m_u16FktId, eseMsg.m_u16DataLen));

      vd_adr3Msg_If::vSendMsg(VD_ADR3_INST_ID_LS_1, eseMsg.m_u16FktId, eseMsg.m_u8adrOptype
         , eseMsg.m_u16DataLen, eseMsg.m_pu8Data, eseMsg.m_u8ThreadMessageType);

      ETG_TRACE_USR4(("Message processed. Messages left: %i", m_EngineSoundMessageQueue.size()));

      //disable the queue until ESE Off is completed in ADR
      if((eseMsg.m_u16FktId == (tU16)VD_ADR3_FKT_ID_ENGINE_SOUND_ONOFF) && (eseMsg.m_u8adrOptype == VD_ADR3_OPTYPE_SET)
          && (!eseMsg.m_pu8Data[0]))
      {
        vStartEngineSoundSetTimer(ESE_SET_TIMER_INTERVAL);
      }
   }
}

void EngineSoundMsgQueue::vAdrReady()
{
   ETG_TRACE_USR4(("EngineSoundMsgQueue::vAdrReady() entered."));
   if (m_EngineSoundMessageQueue.empty())
   {
      ETG_TRACE_USR4(("EngineSoundMessageQueue is empty. Processing stopped."));
      m_bProcessingMessages = false;
   }
   else
   {
      vProcessQueue();
   }
}

void EngineSoundMsgQueue::vEnableQueue()
{
   if (!m_bQueueEnabled){
      m_bQueueEnabled = true;
      vProcessQueue();
   }
}

/*******************************************************************************
 *
 * FUNCTION: EngineSoundMsgQueue::vCreateEngineSoundSetTimer(void)
 *
 * DESCRIPTION: Just a wrapper function to create timer of the application
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tVoid EngineSoundMsgQueue::vCreateEngineSoundSetTimer(tVoid)
{
  ETG_TRACE_USR4(("EngineSoundMsgQueue::vCreateEngineSoundSetTimer() entered."));
  // create speed handler timer
  if(OSAL_OK == OSAL_s32TimerCreate( (OSAL_tpfCallback)vEngineSoundTimerCallback,
      0, &m_hESETimer ))
  ETG_TRACE_USR1(("create ESE_onoff_timer"));

}

/*******************************************************************************
 *
 * FUNCTION: tVoid EngineSoundMsgQueue::vStartEngineSoundSetTimer(tU16 uwTimeMs)
 *
 * DESCRIPTION: Just a wrapper function to start timer of the application
 *
 * PARAMETER: [IN] nTimerTickInterval
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tVoid EngineSoundMsgQueue::vStartEngineSoundSetTimer(tU16 uwTimeMs)
{
  ETG_TRACE_USR4(("EngineSoundMsgQueue:: vStartEngineSoundSetTimer uwTimeMs = %u ", (tU32)uwTimeMs));

  if(OSAL_OK == OSAL_s32TimerSetTime( m_hESETimer, (tU32)uwTimeMs, 0 ))
  {
    ETG_TRACE_USR4(("EngineSoundMsgQueue:: vStartEngineSoundSetTimer OSAL_OK"));
    m_bQueueEnabled = false; //disable queue until timer expiry
  }

  else
  ETG_TRACE_USR4(("EngineSoundMsgQueue:: vStartEngineSoundSetTimer OSAL_ERROR"));
}

/*******************************************************************************
*
* FUNCTION: tVoid EngineSoundMsgQueue::vEngineSoundTimerCallback(void)
*
* DESCRIPTION: Call back function called after expiry of the time interval
*
* PARAMETER: None

*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid EngineSoundMsgQueue::vEngineSoundTimerCallback(tVoid* pArg)
{
  (tVoid)pArg;    // unused parameter
  ETG_TRACE_USR4(("EngineSoundMsgQueue:: vEngineSoundTimerCallback"));
  if(m_pothisInstance->m_asynccall)
    m_pothisInstance->m_asynccall->vCall<EngineSoundMsgQueue>(m_pothisInstance, &EngineSoundMsgQueue::vEnableQueue);
}
