/**
 * @file EngineSoundDIVI.h
 * @author RBEI pau4kor, prm4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ENGINESOUNDMODEL_H_
#define ENGINESOUNDMODEL_H_

#include <system_types.h>

#include "EngineSoundConfigIVI.h"

class EngineSoundModel
{
public:
   EngineSoundModel();
   ~EngineSoundModel();

   /**
    * @brief Function to re-load the data models from Dp, for e.g. on a def-set
    */
   tVoid vReload();

   /**
    * @brief Functions to Set/Get the data model elements
    */
   tVoid vSetActiveESEDriveMode(tU8 u8DriveMode);
   tU8 u8GetActiveESEDriveMode() const;

   tVoid vSetActiveESESoundType(tU8 u8SoundType);
   tU8 u8GetActiveESESoundType() const;

   tVoid vSetActiveESEVolumeLevel(tU8 u8VolumeLevel);
   tU8 u8GetActiveESEVolumeLevel() const;

   tVoid vSetActiveRSoundStatus(tU8 u8Status);
   tU8 u8GetActiveRSoundStatus() const;

   tVoid vSetActiveRSoundType(tU8 u8SoundType);
   tU8 u8GetActiveRSoundType() const;

   tVoid vSetActiveRSoundVolumeLevel(tU8 u8VolumeLevel);
   tU8 u8GetActiveRSoundVolumeLevel() const;

   tVoid vSetActiveRSoundActivationStatus(tU8 u8RSoundActivationStatus);
   tU8 u8GetActiveRSoundActivationStatus() const;

private:
   /**
    * @brief Functions to sync data models with their Dp elements
    */
   tVoid vStoreESEDriveMode(tU8 u8DriveMode);
   tVoid vStoreESESoundType(tU8 u8DriveMode, tU8 u8SoundType);
   tVoid vStoreESEVolumeLevel(tU8 u8DriveMode, tU8 u8SoundType, tU8 s8VolumeLevel);
   tVoid vStoreRSoundStatus(tU8 u8Status);
   tVoid vStoreRSoundType(tU8 u8SoundType);
   tVoid vStoreRSoundVolumeLevel(tU8 u8VolumeLevel);
   tVoid vStoreRSoundActivationStatus(tU8 u8RSoundActivationStatus);

   tU8 u8GetESEDriveMode();
   tU8 u8GetESESoundType(tU8 u8DriveMode);
   tU8 u8GetESEVolumeLevel(tU8 u8DriveMode, tU8 u8SoundType);
   tU8 u8GetRSoundStatus();
   tU8 u8GetRSoundType();
   tU8 u8GetRSoundVolumeLevel();
   tU8 u8GetRSoundActivationStatus();

   tS32 s32SetGetDpItem(tU8 u8DpId, tU8& u8Value, tBool blSet);

   /**
    * @brief data models.
    */
   tU8 m_u8ESEDriveMode;
   tU8 m_u8ESESoundType;
   tU8 m_u8ESEVolumeLevel;

   tU8 m_u8RSoundStatus;
   tU8 m_u8RSoundType;
   tU8 m_u8RSoundVolumeLevel;
   tU8 m_u8RSoundActivationStatus;
};

#endif /* ENGINESOUNDMODEL_H_ */
