/**
 * @file EngineSoundAdrInterface.h
 * @author CM-AI wie1hi, prm4kor
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ENGINESOUNDMESSAGE_H_
#define ENGINESOUNDMESSAGE_H_

class EngineSoundMessage
{
public:
  EngineSoundMessage(tU8 u8AdrOptype, tU16 u16FktId, tU8 u8MessageType, tU16 u16Len, tU8* pu8Data);

  //Special constructor for ESE-Parameter message to create ESE-File parameter
  EngineSoundMessage(tU32 u32Version, tU8 u8FileId, const tU8* pu8Data, tU16 u16Len);

  EngineSoundMessage(const EngineSoundMessage& e);
  ~EngineSoundMessage();

  tU8   m_u8adrOptype;
  tU16  m_u16FktId;
  tU8   m_u8ThreadMessageType;
  tU16  m_u16DataLen;
  tU8*  m_pu8Data;

  tU32 GetCrc32() const;
private:
  EngineSoundMessage& operator=(const EngineSoundMessage& e); //disallow = operator
  bool operator==(const EngineSoundMessage& e) const; //disallow == operator
  bool operator!=(const EngineSoundMessage& e) const; //disallow != operator
};
#endif /* ENGINESOUNDMESSAGE_H_ */

