/**
 * @file EngineSoundMsgQueue.cpp
 * @author CM-AI prm4kor
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include <ahl_if.h>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ENGINESOUND
#include "trcGenProj/Header/EngineSoundMessage.cpp.trc.h"
#endif

#include "EngineSoundMessage.h"
#include "EngineSoundConfigIVI.h"
#include "../../../../../di_commonbase/components/ahl/ahl_Crc.h"
#include "aud_sinkmanager/vd_adr3/vd_adr3Message_Data.h"
#include "aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"

EngineSoundMessage::EngineSoundMessage(tU8 u8AdrOptype, tU16 u16FktId, tU8 u8MessageType, tU16 u16Len, tU8* pu8Data):
          m_u8adrOptype(u8AdrOptype),
          m_u16FktId(u16FktId),
          m_u8ThreadMessageType(u8MessageType),
          m_u16DataLen(u16Len),
          m_pu8Data(NULL)
{
  if(pu8Data && (m_u16DataLen > 0))
  {
    m_pu8Data = new tU8[m_u16DataLen];

    if(m_pu8Data)
      memcpy(m_pu8Data,pu8Data,m_u16DataLen);
  }
}

EngineSoundMessage::EngineSoundMessage(tU32 u32Version, tU8 u8FileId, const tU8* pu8Data, tU16 u16Len):
          m_u8adrOptype(VD_ADR3_OPTYPE_SET),
          m_u16FktId(VD_ADR3_FKT_ID_ENGINE_SOUND_PARAMETER),
          m_u8ThreadMessageType(ENGINE_SOUND_PARAMETER),
          m_u16DataLen((tU16)(u16Len+ESE_FILE_OVERHEAD_SIZE)),
          m_pu8Data(NULL)
{
  if(pu8Data && (m_u16DataLen > ESE_FILE_OVERHEAD_SIZE))
  {
    tU32 crc = 0;
    m_pu8Data = new tU8[m_u16DataLen];

    if(m_pu8Data)
    {
      // VERSION
      // u32Version = htonl(u32Version);
      memcpy(m_pu8Data, &u32Version, sizeof(tU32));

      // FILE-ID
      m_pu8Data[ESE_FILE_HEADER_SIZE - 1] = u8FileId;

      // DATA
      memcpy(&m_pu8Data[ESE_FILE_HEADER_SIZE], pu8Data, u16Len);

      // CRC 32
      ahl_calc_crc_32(m_pu8Data, u16Len + ESE_FILE_HEADER_SIZE, &crc);
      memcpy(&m_pu8Data[u16Len + ESE_FILE_HEADER_SIZE], &crc, sizeof(tU32));
    }

    ETG_TRACE_USR4(("EngineSoundMessage: Add ESE-Parameter message to queue for File-ID %i: Version:%08x, Checksum:%08x", u8FileId, u32Version, crc));
  }
}

EngineSoundMessage::~EngineSoundMessage()
{
  if(m_pu8Data)
    delete[] m_pu8Data;

  m_pu8Data = NULL;
}

EngineSoundMessage::EngineSoundMessage(const EngineSoundMessage& e)
{
  m_u8adrOptype      =  e.m_u8adrOptype;
  m_u16FktId        =  e.m_u16FktId;
  m_u8ThreadMessageType  =  e.m_u8ThreadMessageType;

  m_pu8Data        =  NULL;
  m_u16DataLen      =  0;

  if (e.m_pu8Data != NULL && e.m_u16DataLen > 0)
  {
    m_pu8Data = new tU8[e.m_u16DataLen];

    if (m_pu8Data != NULL)
    {
      m_u16DataLen = e.m_u16DataLen;
      memcpy(m_pu8Data, e.m_pu8Data, m_u16DataLen);
    }
  }
}


tU32 EngineSoundMessage::GetCrc32() const
{
   tU32 crc = 0;
   NORMAL_M_ASSERT(m_u16DataLen >= sizeof(tU32));
   if (m_pu8Data != NULL && m_u16DataLen >= sizeof(tU32))
   {
      //lint -save -e826 Suspicious pointer-to-pointer conversion (area too small) --> This is secured by check of m_DataSize
      crc = *((tU32*)&m_pu8Data[m_u16DataLen - sizeof(tU32)]);
      //lint -restore
   }
   return crc;
}

