/**
 * @file EngineSoundConfigIVI.h
 * @author RBEI pau4kor
 * @copyright (c) 2016 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ENGINESOUNDCONFIGIVI_H_
#define ENGINESOUNDCONFIGIVI_H_

#ifndef ASSERT_STATIC
// from http://stackoverflow.com/a/3385694:
#define ASSERT_STATIC(X) (/*lint -save -e1717*/{ extern int __attribute__((error("assertion failure: '" #X "' not true"))) compile_time_check(); ((X)?0:compile_time_check()),0; }/*lint -restore*/)
#endif

#ifndef NULL
#define NULL (void*)0
#endif

#define ESE_ADR_FILE_VERSION  0x1A011001 //Day(26),  Version(01),  Year(16), Month(01)

#define ESE_PARAM_SIZE_MEX    3998
#define ESE_PARAM_SIZE_RSOUND 5478
#define EOL_HEADER_SIZE      32
#define EOL_CRC_SIZE          2

#define NUM_OF_MEXSOUND          3
#define NUM_OF_MEXSOUND_IN_EOL   3
#define NUM_OF_RSOUND_IN_EOL     4

#define ENGINE_SOUND_DATA_SIZE_BYTES (EOL_HEADER_SIZE+(NUM_OF_MEXSOUND_IN_EOL*ESE_PARAM_SIZE_MEX)+(NUM_OF_RSOUND_IN_EOL*ESE_PARAM_SIZE_RSOUND)+EOL_CRC_SIZE)

#define ENGINE_SOUND_NUMBER_OF_ESE_FILES (5)

#define ESE_FILE_HEADER_SIZE   (5)
#define ESE_FILE_CRC_SIZE      (4)
#define ESE_FILE_MAX_SIZE      (2000)
#define ESE_FILE_OVERHEAD_SIZE (ESE_FILE_HEADER_SIZE + ESE_FILE_CRC_SIZE)
#define ESE_FILE_MAX_PAYLOAD   (ESE_FILE_MAX_SIZE - ESE_FILE_OVERHEAD_SIZE)

#define EOL_INDEX_NEUTRAL_DATA   EOL_HEADER_SIZE
#define EOL_INDEX_SOUND1_DATA    (EOL_INDEX_NEUTRAL_DATA + ESE_PARAM_SIZE_MEX)
#define EOL_INDEX_SOUND2_DATA    (EOL_INDEX_SOUND1_DATA + ESE_PARAM_SIZE_MEX)
#define EOL_INDEX_RSOUND1_DATA   (EOL_INDEX_SOUND2_DATA + ESE_PARAM_SIZE_MEX)
#define EOL_INDEX_RSOUND2_DATA   (EOL_INDEX_RSOUND1_DATA + ESE_PARAM_SIZE_RSOUND)
#define EOL_INDEX_RSOUND3_DATA   (EOL_INDEX_RSOUND2_DATA + ESE_PARAM_SIZE_RSOUND)
#define EOL_INDEX_RSOUND4_DATA   (EOL_INDEX_RSOUND3_DATA + ESE_PARAM_SIZE_RSOUND)

#define MAX_RSOUND_VOL_STEP 14
typedef enum
{
   ENGINESOUND_DRIVEMODE_ECO = 0,
   ENGINESOUND_DRIVEMODE_COMFORT,
   ENGINESOUND_DRIVEMODE_NORMAL,
   ENGINESOUND_DRIVEMODE_DYNAMIC,
   ENGINESOUND_DRIVEMODE_PERSO
} tenEngineSoundDriveMode;

typedef enum
{
   ENGINESOUND_SOUNDTYPE_NEUTRAL = 1,
   ENGINESOUND_SOUNDTYPE_SOUND1 = 2,
   ENGINESOUND_SOUNDTYPE_SOUND2 = 3,
   ENGINESOUND_SOUNDTYPE_RSOUND1 = 4,
   ENGINESOUND_SOUNDTYPE_RSOUND2 = 5,
   ENGINESOUND_SOUNDTYPE_RSOUND3 = 6,
   ENGINESOUND_SOUNDTYPE_RSOUND4 = 7,
   ENGINESOUND_SOUNDTYPE_RSOUND5 = 8,
   ENGINESOUND_SOUNDTYPE_RSOUND6 = 9
} tenEngineSoundSoundType;

typedef enum
{
   ENGINESOUND_VOLUME_OFF = 1,
   ENGINESOUND_VOLUME_LOW = 2,
   ENGINESOUND_VOLUME_HIGH = 3
} tenEngineSoundVolume;

typedef enum
{
   RSOUND_ONOFF_OFF = 0,
   RSOUND_ONOFF_ON
}tenRSoundOnOff;

typedef enum
{
   RSOUND_ACTIVATION_OFF = 0,
   RSOUND_ACTIVATION_ON
}tenRSoundActivation;

//structure for storing the version map contents
struct tESEVersionMap
{
  tU8 u8ESELibMajVersion;
  tU8 u8ESELibMinVersion;
  tU8 u8ESEEOLMajVersion;
  tU16 u16ESEEOLMinVersion;
  inline /*constructor*/
  tESEVersionMap(tU8 ESELibMajVersion, tU8 ESELibMinVersion, tU8 ESEEOLMajVersion, tU16 ESEEOLMinVersion)
  :u8ESELibMajVersion(ESELibMajVersion), u8ESELibMinVersion(ESELibMinVersion),//ESE lib version in ADR
   u8ESEEOLMajVersion(ESEEOLMajVersion), u16ESEEOLMinVersion(ESEEOLMinVersion) //ESE lib version in EOL
  {};
};
#endif /* ENGINESOUNDCONFIGIVI_H_ */
