/**
 * @file fcaudiomanager_Speaker_Diagnosis.cpp
 * @author CM-AI wie1hi
 * @copyright (c) 2014 Robert Bosch Car Multimedia GmbH
 * @addtogroup fc_audiomanager
 * @{
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>   // implicitly links "osal_if.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include <midw_fi_if.h>

#include "fc_audiomanager_Speaker_Diagnosis.h"

//#include "../fc_audiomanager_service_Audio_Function.h"
//#include "../fc_audiomanager_main.h"

#include "../fc_audiomanager_trace.h"
//
//#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_audio_if.h"
//
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SPEAKER_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_Speaker_Diagnosis.cpp.trc.h"
#endif

//#include "../../PostOffice/PostOffice.hpp"
//#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
//#include "../InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_VolumeStatus.h"
//#include "../InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"

#include "../InternalComponentCommunication/Messages/Diag/IDStartDiagTest.h"
#include "../InternalComponentCommunication/Messages/Diag/IDGetDiagStatus.h"
#include "../InternalComponentCommunication/Messages/Diag/IDGetDiagResult.h"
#include "../InternalComponentCommunication/Messages/Diag/IDNotifyDiagStatus.h"
#include "../InternalComponentCommunication/Messages/Startup/IDNotifyStartup.h"
#include "../InternalComponentCommunication/Messages/SoundConfig/IDSetSoundSystemConfig.h"
//#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3Startup.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3DiagType.h"
//#include "../util/Macro.h"

#include "../../../../../di_frameworks/components/ail/include/ail_ListTypes.h"
#include "../aud_sinkmanager/vd_adr3/vd_adr3Msg_If.h"

tBool fc_audiomanager_tclSpeaker_Diagnosis::bStartDiagTest = TRUE;  //modified to start diagtest via TTFis command

/**
 * Constructor
 */
fc_audiomanager_tclSpeaker_Diagnosis::fc_audiomanager_tclSpeaker_Diagnosis
   (fc_audiomanager_tclService_Audio_Function* poService)
   : IF_MessageObserver<PO_MessageConfig::enID>("fc_audiomanager_tclSpeaker_Diagnosis")
{
   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis() entered."));
   m_poAudioService = poService;
   pPO = InternalCommunicationAdapter::getInstance();
   m_u8SoundSystemconfig = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1;
   if (pPO == OSAL_NULL)
   {
      ETG_TRACE_FATAL(("fc_audiomanager_tclSpeaker_Diagnosis: InternalCommunicationAdapter returned NULL pointer"));
      NORMAL_M_ASSERT_ALWAYS();
   }

   // Fill vector with "not tested" values
   midw_fi_tcl_Aud_MeasurementResultItem oResultItem;
   oResultItem.b32Result.u32Value = (midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED |
                                     midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED |
                                     midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED |
                                     midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED |
                                     midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED);

#define INSERT_CHANNEL_ITEM(_channel) \
   oResultItem.u8DataId.enType = _channel; \
   mReadMeasurementResultStatus.MeasurementResultList.push_back(oResultItem);

   INSERT_CHANNEL_ITEM(midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF)
   INSERT_CHANNEL_ITEM(midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RF)
   INSERT_CHANNEL_ITEM(midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LR)
   INSERT_CHANNEL_ITEM(midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RR)
   INSERT_CHANNEL_ITEM(midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_CE)
   INSERT_CHANNEL_ITEM(midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_SUB)

   SetDiagMode(midw_fi_tcl_e8_DiagMode::FI_EN_OFF, midw_fi_tcl_e8_DiagMode::FI_EN_OFF);

   vAddObserver();
   //ID_StartDiagTest oStartDiagTest(EN_AUDIO_DIAG_DC_OFF,EN_AUDIO_DIAG_AC_OFF,EN_AUDIO_DIAG_PERM_CONTINUOUS_QUALIFIED);
   //InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oStartDiagTest);   //these things may be needed on receiving ID_notifyStartUp to set all to OFF, if ADR3 is not setting them to OFF
   //vCheckDiagStatus();//get latest diag status
}

/**
 * Destructor
 */

fc_audiomanager_tclSpeaker_Diagnosis::~fc_audiomanager_tclSpeaker_Diagnosis()
{
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
   m_poAudioService = NULL;
   pPO = NULL;
}

/**
 * tVoid GetTestResult(midw_mascffi_tclMsgReadMeasurementResultStatus *outMeasurementResult);
 *
 * @param[out] outMeasurementResult Pointer to variable to receive measurement result
 */
tVoid fc_audiomanager_tclSpeaker_Diagnosis::GetTestResult(midw_mascffi_tclMsgReadMeasurementResultStatus *outMeasurementResult)
{
   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::GetTestResult() entered."));
   *outMeasurementResult = mReadMeasurementResultStatus;
}

/**
 * Subscribe as observer for the relevant messages
 */
void fc_audiomanager_tclSpeaker_Diagnosis::vAddObserver()
{
   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::vAddObserver() entered"));

   if(pPO != NULL)
   {
      // add notifiers
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyDiagResult);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyDiagStatus);
      pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyStartup);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::IDSetSoundSystemConfig);
   }
   else
   {
      FATAL_M_ASSERT_ALWAYS();
   }
}

/**
 * SetDiagMode()
 *
 * Sets the diag mode that was used for DiagnosisSpeaker.
 * This function is called when DiagnosisSpeaker command
 * is sent to the ADR3 in fc_audiomanager_service_Audio_Function.cpp
 *
 */
tVoid fc_audiomanager_tclSpeaker_Diagnosis::SetDiagMode(midw_fi_tcl_e8_DiagMode::tenType modeDC, midw_fi_tcl_e8_DiagMode::tenType modeAC)
{
   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::SetDiagMode() entered."));
   mDiagModeDC.enType = modeDC;
   mDiagModeAC.enType = modeAC;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   if((m_poAudioService))
   {
      if(!(m_poAudioService->u8CheckTweeterAvailability()))
         mDiagModeAC.enType = midw_fi_tcl_e8_DiagMode::FI_EN_OFF;
   }
#endif
}

tVoid fc_audiomanager_tclSpeaker_Diagnosis::SetDiagMode(tenSpeakerModeDC modeDC, tenSpeakerModeAC modeAC)
{
   SetDiagMode(speakerModeADR2Fi_DC(modeDC), speakerModeADR2Fi_AC(modeAC));
}

/**
 * SiteADRToFi()
 *
 * Convert ADR error site to fi error site
 * @param[in]: ADR type of Error Site
 */
midw_fi_tcl_e8_Aud_DataId::tenType fc_audiomanager_tclSpeaker_Diagnosis::SiteADRToFi(tenErrorSite adrErrorSite)
{
      switch (adrErrorSite)
      {
         case EN_AUDIO_DIAG_SPEAKER_LF:  return midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF;
         case EN_AUDIO_DIAG_SPEAKER_RF:  return midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RF;
         case EN_AUDIO_DIAG_SPEAKER_LR:  return midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LR;
         case EN_AUDIO_DIAG_SPEAKER_RR:  return midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RR;
         case EN_AUDIO_DIAG_SPEAKER_CE:  return midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_CE;
         case EN_AUDIO_DIAG_SPEAKER_SUB: return midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_SUB;
         default:
            // Never come here! Exclude this case before call to this function.
            NORMAL_M_ASSERT_ALWAYS();
            return midw_fi_tcl_e8_Aud_DataId::FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF;
         break;
      }
}
/**
 * Type conversion function speakerModeFi2ADR_DC()
 */
tenSpeakerModeDC                fc_audiomanager_tclSpeaker_Diagnosis::speakerModeFi2ADR_DC(midw_fi_tcl_e8_DiagMode::tenType fiMode)
{
   tenSpeakerModeDC ret = (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_OFF)         ? EN_AUDIO_DIAG_DC_OFF :
                          (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_UNQUALIFIED) ? EN_AUDIO_DIAG_DC_SINGLE :
                          (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED)   ? EN_AUDIO_DIAG_DC_SINGLE_QUALIFIED :
                          (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_CONTINOUS)   ? EN_AUDIO_DIAG_DC_CONTINUOUS_QUALIFIED :
                          EN_AUDIO_DIAG_DC_UNDEF;
   if (ret == EN_AUDIO_DIAG_DC_UNDEF)
   {
      ETG_TRACE_USR1(("speakerModeFi2ADR_DC: Passed undefined speaker mode value."));
   }
   return ret;
}

/**
 * Type conversion function speakerModeFi2ADR_AC()
 */
tenSpeakerModeAC                fc_audiomanager_tclSpeaker_Diagnosis::speakerModeFi2ADR_AC(midw_fi_tcl_e8_DiagMode::tenType fiMode)
{
   tenSpeakerModeAC ret =  (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_OFF)         ? EN_AUDIO_DIAG_AC_OFF :
                           (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_UNQUALIFIED) ? EN_AUDIO_DIAG_AC_SINGLE :
                           (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED)   ? EN_AUDIO_DIAG_AC_SINGLE_QUALIFIED :
                           (fiMode == midw_fi_tcl_e8_DiagMode::FI_EN_CONTINOUS)   ? EN_AUDIO_DIAG_AC_CONTINUOUS_QUALIFIED :
                           EN_AUDIO_DIAG_AC_UNDEF;
   if (ret == EN_AUDIO_DIAG_AC_UNDEF)
   {
      ETG_TRACE_USR1(("speakerModeFi2ADR_DC: Passed undefined speaker mode value."));
   }
   return ret;
}

/**
 * Type conversion function speakerModeFi2ADR_DC()
 */
midw_fi_tcl_e8_DiagMode::tenType fc_audiomanager_tclSpeaker_Diagnosis::speakerModeADR2Fi_DC(tenSpeakerModeDC adrMode)
{
   if (adrMode == EN_AUDIO_DIAG_DC_UNDEF)
   {
      ETG_TRACE_USR1(("speakerModeADR2Fi_DC: Passed speaker mode value 'undefined'."));
   }
   return (adrMode == EN_AUDIO_DIAG_DC_OFF)                    ? midw_fi_tcl_e8_DiagMode::FI_EN_OFF :
          (adrMode == EN_AUDIO_DIAG_DC_SINGLE )                ? midw_fi_tcl_e8_DiagMode::FI_EN_UNQUALIFIED :
          (adrMode == EN_AUDIO_DIAG_DC_SINGLE_QUALIFIED )      ? midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED :
          midw_fi_tcl_e8_DiagMode::FI_EN_CONTINOUS;
}

/**
 * Type conversion function speakerModeFi2ADR_AC()
 */
midw_fi_tcl_e8_DiagMode::tenType fc_audiomanager_tclSpeaker_Diagnosis::speakerModeADR2Fi_AC(tenSpeakerModeAC adrMode)
{
   if (adrMode == EN_AUDIO_DIAG_AC_UNDEF)
   {
      ETG_TRACE_USR1(("speakerModeADR2Fi_AC: Passed speaker mode value 'undefined'."));
   }
   return (adrMode == EN_AUDIO_DIAG_AC_OFF)                    ? midw_fi_tcl_e8_DiagMode::FI_EN_OFF :
          (adrMode == EN_AUDIO_DIAG_AC_SINGLE )                ? midw_fi_tcl_e8_DiagMode::FI_EN_UNQUALIFIED :
          (adrMode == EN_AUDIO_DIAG_AC_SINGLE_QUALIFIED )      ? midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED :
          midw_fi_tcl_e8_DiagMode::FI_EN_CONTINOUS;
}

/**
 * This function is called on receiving status notification
 *
 * @param[in] MsgId The message id of the SpeakerDiagnosis message
 */
void fc_audiomanager_tclSpeaker_Diagnosis::MessageNotification(PO_MessageConfig::enID MsgId)
{
   if (MsgId == PO_MessageConfig::ID_NotifyDiagResult)
   {
      ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis: ID_NotifyDiagResult received."));
      const ID_NotifyDiagResult* pMsg = pPO->POMessages->QueryMessage<ID_NotifyDiagResult>(MsgId);

      SpeakerDiagnosisResultList diagResultList;

      diagResultList.enErrorSite = pMsg -> enErrorSite;
      diagResultList.DetailList.push_back(std::pair<tenErrorCode, tenErrorValue>(pMsg->enErrorCode, pMsg->enErrorValue));

      // Ignore error sites other than speakers
      if (pMsg->enErrorSite > EN_AUDIO_DIAG_SPEAKER_SUB)
      {
         ETG_TRACE_USR3(("ErrorSite 0x%02x not relevant for speaker diagnosis.", diagResultList.enErrorSite));
         return;
      }

      // Translate errorSite: ADR -> fi
      midw_fi_tcl_e8_Aud_DataId::tenType fiErrorSite = SiteADRToFi(diagResultList.enErrorSite);

      std::vector<std::pair<tenErrorCode, tenErrorValue> >::iterator it;

      for (it = diagResultList.DetailList.begin(); it != diagResultList.DetailList.end(); ++it)
      {
         tenErrorCode errorCode = it->first;
         tenErrorValue errorValue = it->second;
         ETG_TRACE_USR4(("SpeakerDiagnosis: ErrorSite:     %02x / fi:0x%02x", ETG_CENUM(tenErrorSite, diagResultList.enErrorSite), fiErrorSite));
         ETG_TRACE_USR4(("SpeakerDiagnosis:    ErrorCode:  %02x", ETG_CENUM(tenErrorCode, errorCode)));
         ETG_TRACE_USR4(("SpeakerDiagnosis:    ErrorValue: %02x", ETG_CENUM(tenErrorValue, errorValue)));

         // Find affected value in vector
         vector<midw_fi_tcl_Aud_MeasurementResultItem>::iterator itResultItem;
         vector<midw_fi_tcl_Aud_MeasurementResultItem>* v = &mReadMeasurementResultStatus.MeasurementResultList;
         for (itResultItem = v -> begin(); itResultItem != v -> end(); ++itResultItem)
         {
            if (itResultItem -> u8DataId.enType == fiErrorSite)
            {
               // Set diag mode
               switch (mDiagModeDC.enType)
               {
               case midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED:
                  itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED;
                  itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED;
                  break;
               default:
                  itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED;
                  itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED;
               }
               switch (mDiagModeAC.enType)
               {
               case midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED:
                  itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED;
                  itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED;
                  break;
               default:
                  itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED;
                  itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED;
               }

               switch (errorCode)
               {
               case EN_AUDIO_DIAG_ERR_OPEN_WOOFER:
                  switch (errorValue)
                  {
                     case EN_AUDIO_DIAG_ERRVAL_NO_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_CONDITION:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED;
                        break;
                     default:
                        ETG_TRACE_USR1(("DiagnosisSpeaker MessageNotification: "
                              "DiagnosisErrorValue for WOOFER not specified (is 0x%02x, but should be 0x01..0x03)", errorValue));
                        break;
                  }
                  break;
               case EN_AUDIO_DIAG_ERR_SHORT_GND:
                  switch (errorValue)
                  {
                     case EN_AUDIO_DIAG_ERRVAL_NO_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_OK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_ERROR;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_CONDITION:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED;
                        break;
                     default:
                        ETG_TRACE_USR1(("DiagnosisSpeaker MessageNotification: "
                              "DiagnosisErrorValue for SHORT_GND not specified (is 0x%02x, but should be 0x01..0x03)", errorValue));
                        break;
                  }
                  break;
               case EN_AUDIO_DIAG_ERR_SHORT_VCC:
                  switch (errorValue)
                  {
                     case EN_AUDIO_DIAG_ERRVAL_NO_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_OK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_CONDITION:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED;
                        break;
                     default:
                        ETG_TRACE_USR1(("DiagnosisSpeaker MessageNotification: "
                              "DiagnosisErrorValue for SHORT_VCC not specified (is 0x%02x, but should be 0x01..0x03)", errorValue));
                        break;
                  }
                  break;
               case EN_AUDIO_DIAG_ERR_SHORT_WIRE:
                  switch (errorValue)
                  {
                     case EN_AUDIO_DIAG_ERRVAL_NO_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_OK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_ERROR;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_CONDITION:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED;
                        break;
                     default:
                        ETG_TRACE_USR1(("DiagnosisSpeaker MessageNotification: "
                              "DiagnosisErrorValue for SHORT_WIRE not specified (is 0x%02x, but should be 0x01..0x03)", errorValue));
                        break;
                  }
                  break;
               case EN_AUDIO_DIAG_ERR_OPEN_TWEETER:
                  switch (errorValue)
                  {
                     case EN_AUDIO_DIAG_ERRVAL_NO_ERROR:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_ERROR:
            AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poAudioService);

            if(m_poAudioService->bIsTweeterConfigured(pMsg -> enErrorSite) == FALSE)
            {
                           //Tweeter is not configured, so set the NOT_TESTED, even if there is an error
              itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED;
              itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR;
            }
            else
            {
                           //Tweeter is configured, so set result to ERROR
              itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR;
              itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED;
            }

                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK;
                        break;
                     case EN_AUDIO_DIAG_ERRVAL_CONDITION:
                        itResultItem -> b32Result.u32Value |= midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK;
                        // Delete others
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR;
                        itResultItem -> b32Result.u32Value &= ~midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED;
                        break;
                     default:
                        ETG_TRACE_USR1(("DiagnosisSpeaker MessageNotification: "
                              "DiagnosisErrorValue for OPEN_TWEETER not specified (is 0x%02x, but should be 0x01..0x03)", errorValue));
                        break;
                  }
                  break;
               default:
                  break;
               }

               tU32 val = itResultItem -> b32Result.u32Value;
               ETG_TRACE_USR4(("--- DiagnosisSpeaker: bitfield for site/code/value: 0x%02x/0x%02x/0x%02x----------->"
                                    , diagResultList.enErrorSite, errorCode, errorValue));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_OK             ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_GROUND_OK             "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_ERROR          ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_GROUND_ERROR          "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED     ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED     "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK  ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK  "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_OK            ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_BATTERY_OK            "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR         ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR         "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED    ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED    "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_OK                ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORTED_LOAD_OK                "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_ERROR             ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORTED_LOAD_ERROR             "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED        ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED        "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK     ) ETG_TRACE_USR4(("  FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK     "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK            ) ETG_TRACE_USR4(("  FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK            "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR         ) ETG_TRACE_USR4(("  FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR         "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED    ) ETG_TRACE_USR4(("  FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED    "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK ) ETG_TRACE_USR4(("  FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK           ) ETG_TRACE_USR4(("  FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK           "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR        ) ETG_TRACE_USR4(("  FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR        "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED   ) ETG_TRACE_USR4(("  FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED   "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK) ETG_TRACE_USR4(("  FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK"));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED        ) ETG_TRACE_USR4(("  FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED        "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED          ) ETG_TRACE_USR4(("  FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED          "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED        ) ETG_TRACE_USR4(("  FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED        "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED          ) ETG_TRACE_USR4(("  FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED          "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_WOOFER_AVAILABILITY            ) ETG_TRACE_USR4(("  FI_C_U32_BIT_WOOFER_AVAILABILITY            "));
               if (val & midw_fi_tcl_b32_MeasurementResult::FI_C_U32_BIT_TWEETER_AVAILABILITY           ) ETG_TRACE_USR4(("  FI_C_U32_BIT_TWEETER_AVAILABILITY           "));
               ETG_TRACE_USR4(("<-- DiagnosisSpeaker: bitfield for site/code/value: 0x%02x/0x%02x/0x%02x------------"
                                    , diagResultList.enErrorSite, errorCode, errorValue));
            }
         }
      }

      // Notify all subscribers
      ail_tenCommunicationError enResult = m_poAudioService->updateClients(MIDW_MASCFFI_C_U16_READMEASUREMENTRESULT);
      if(enResult != AIL_EN_N_NO_ERROR)
      {
         ETG_TRACE_ERR(("ERR: updateClients(MIDW_MASCFFI_C_U16_READMEASUREMENTRESULT) failed. (%d)", (int)enResult));
      }
   }

   else if (MsgId == PO_MessageConfig::ID_NotifyDiagStatus)
   {
      const ID_NotifyDiagStatus* pMsg = pPO->POMessages->QueryMessage<ID_NotifyDiagStatus>(MsgId);

      ETG_TRACE_USR4(("SpeakerDiagnosis: NotifyDiagStatus received: 0x%02x", pMsg->enDiagnosisStatus));
      vSetDiagTestStatus(pMsg->enDiagnosisStatus);

      if (pMsg -> enDiagnosisStatus == EN_AUDIO_DIAG_OFF ||
          pMsg -> enDiagnosisStatus == EN_AUDIO_DIAG_PERM_RUNNING)
      {
         ETG_TRACE_USR4(("SpeakerDiagnosis: update clients"));
         ail_tenCommunicationError enResult = m_poAudioService->updateClients(MIDW_MASCFFI_C_U16_READMEASUREMENTRESULT);
         if(enResult != AIL_EN_N_NO_ERROR)
         {
            ETG_TRACE_ERR(("ERR: updateClients(MIDW_MASCFFI_C_U16_READMEASUREMENTRESULT) failed. (%d)", (int)enResult));
         }
      }
   }
   else if (MsgId == PO_MessageConfig::ID_NotifyStartup)
   {
      ETG_TRACE_USR4(("SpeakerDiagnosis: NotifyStartup received."));

      const ID_NotifyStartup* pMsg = pPO->POMessages->QueryMessage<ID_NotifyStartup>(MsgId);

      if (pMsg -> enOn == EN_AUDIO_ADR3_AVAILABLE)
      {
     if((m_u8SoundSystemconfig == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM3) ||  (m_u8SoundSystemconfig == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM4)
        || (m_u8SoundSystemconfig == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM8))
      return;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
         if((m_poAudioService))
         {
             if((m_poAudioService->bCheckFaderAvailability() == INTERNALAMP_4SPEAKER) || (m_poAudioService->bCheckFaderAvailability() == INTERNALAMP_2SPEAKER))
       {
        m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_LF);
        m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_RF);

        if(m_poAudioService->bCheckFaderAvailability() == INTERNALAMP_4SPEAKER)
        {
          ETG_TRACE_USR4(("4 Speaker Configuration"));
               m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_LR);
               m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_RR);
        }
       }
         }
#else
    m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_LF);
    m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_RF);
        m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_LR);
        m_poAudioService -> vRequestDiagResult(EN_AUDIO_DIAG_SPEAKER_RR);
#endif
      }
   }
   else if (MsgId == PO_MessageConfig::IDSetSoundSystemConfig)
     vHandleSoundSystemConfig(MsgId);
   else
   {
      // Did not subscribe for other messages, so this code should not be reached.
      assert(false);
   }
}

/********************************************************************************
 * FUNCTION: vStartDiagTest(tU8 uSpeakerModeDC, tU8 uSpeakerModeAC, tU8 uSpeakerModePERM)
 *
 * DESCRIPTION:  This function is called on receiving the command to start diagnosis test
 *
 * PARAMETER:   tU8 uSpeakerModeDC, tU8 uSpeakerModeAC, tU8 uSpeakerModePERM
 *
 * RETURNVALUE:  None
 *******************************************************************************/

void fc_audiomanager_tclSpeaker_Diagnosis::vStartDiagTest(tU8 uSpeakerModeDC, tU8 uSpeakerModeAC, tU8 uSpeakerModePERM)
{

   ETG_TRACE_USR4(("vStartDiagTest received dc: 0x%4x, ac: 0x%4x, perm: 0x%4x", uSpeakerModeDC, uSpeakerModeAC, uSpeakerModePERM));

   ETG_TRACE_USR4(( "bStartDiagTest : %d, m_u8SoundSystemconfig :%d",bStartDiagTest,m_u8SoundSystemconfig));

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   if(m_poAudioService)
   {
      if(!(m_poAudioService->u8CheckTweeterAvailability()))
         {
            ETG_TRACE_USR4(("vStartDiagTest Tweeter not configured. Do not start AC diagnosis "));
            uSpeakerModeAC = EN_AUDIO_DIAG_AC_OFF;
         }
      else
         ETG_TRACE_USR4(("vStartDiagTest Tweeter is configured "));
   }
#endif
   if((m_u8SoundSystemconfig != SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1) &&  (m_u8SoundSystemconfig != SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM2))
   {
     ETG_TRACE_USR4(("m_u8SoundSystemconfig :%d",m_u8SoundSystemconfig));
     uSpeakerModeDC = EN_AUDIO_DIAG_DC_OFF;
     uSpeakerModeAC = EN_AUDIO_DIAG_AC_OFF;
   }
   if(bStartDiagTest)
   {
      //Send the Message to vd_adr3
      ETG_TRACE_USR4(("vStartDiagTest Started"));
      ID_StartDiagTest oStartDiagTest(static_cast<tenSpeakerModeDC>(uSpeakerModeDC), static_cast<tenSpeakerModeAC>(uSpeakerModeAC), static_cast<tenSpeakerModePERM>(uSpeakerModePERM));
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oStartDiagTest);
   }
   else
      ETG_TRACE_USR4(("vStartDiagTest is already in progress"));
   vCheckDiagStatus();//get latest diag status
}

/*************************************************************************
 * FUNCTION:   fc_audiomanager_tclSpeaker_Diagnosis::deliverTTFisMessage(tPCUChar pData)
 *
 * DESCRIPTION:  This function is called on receiving the trace command
 *
 * PARAMETER:    tPCUChar pData
 *
 * RETURNVALUE:  None
 *************************************************************************/
tVoid fc_audiomanager_tclSpeaker_Diagnosis::deliverTTFisMessage(tU32 size, tPCUChar pData)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pData);
   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis: Incoming TTFis Command: SetDiagnosisSpeaker: Data=0x%02x",ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pData)));

   tU8 speakerDC = pData[2];
   tU8 speakerAC = pData[3];
   tU8 speakerPERM = pData[4];

   vStartDiagTest(speakerDC, speakerAC, speakerPERM);
}

/********************************************************************************
 * FUNCTION: vOnAbortDiagTest()
 *
 * DESCRIPTION:  This function is called on receiving the command to abort diagnosis test
 *
 * PARAMETER:   None
 *
 * RETURNVALUE:  None
 *******************************************************************************/
void fc_audiomanager_tclSpeaker_Diagnosis::vOnAbortDiagTest()
{

   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::vOnAbortDiagTest entered."));

   if(bStartDiagTest)
   {
      //Send the Message to vd_adr3
      tU8 uSpeakerModeDC = EN_AUDIO_DIAG_DC_OFF;
      tU8 uSpeakerModeAC =  EN_AUDIO_DIAG_AC_OFF;
      tU8 uSpeakerModePERM = EN_AUDIO_DIAG_PERM_CONTINUOUS_QUALIFIED;

      //start default diag test
      ID_StartDiagTest oStartDiagTest(static_cast<tenSpeakerModeDC>(uSpeakerModeDC), static_cast<tenSpeakerModeAC>(uSpeakerModeAC), static_cast<tenSpeakerModePERM>(uSpeakerModePERM));
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oStartDiagTest);

      bStartDiagTest = FALSE;
   }
   else
      ETG_TRACE_USR4(("vOnAbortDiagTest:: Diagnosis Test is already completed"));

}

/********************************************************************************
 * FUNCTION: vSetDiagTestStatus(tenDiagnosisStatus enDiagnosisStatus)
 *
 * DESCRIPTION:  This function is called to check whether a diag test is in execution
 *
 * PARAMETER:   tenDiagnosisStatus enDiagnosisStatus
 *
 * RETURNVALUE:  None
 *******************************************************************************/

void fc_audiomanager_tclSpeaker_Diagnosis::vSetDiagTestStatus(tenDiagnosisStatus enDiagnosisStatus)
{

   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::vSetDiagTestStatus entered : 0x%4x", enDiagnosisStatus));

   if(enDiagnosisStatus == EN_AUDIO_DIAG_DC_RUNNING || enDiagnosisStatus == EN_AUDIO_DIAG_AC_RUNNING)
   {
      ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::vSetDiagTestStatus Test is in progress"));
      bStartDiagTest = FALSE;
   }
   else
   {
      ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::vSetDiagTestStatus Test execution is completed"));
      bStartDiagTest = TRUE;
   }
}

/********************************************************************************
 * FUNCTION: vCheckDiagStatus()
 *
 * DESCRIPTION:  This function is called to check if a diagnosis test is already running
 *
 * PARAMETER:   None
 *
 * RETURNVALUE:  None
 *******************************************************************************/

void fc_audiomanager_tclSpeaker_Diagnosis::vCheckDiagStatus()
{

   ETG_TRACE_USR4(("fc_audiomanager_tclSpeaker_Diagnosis::vCheckDiagStatus entered"));

   //Send the Message to vd_adr3
   ID_GetDiagStatus oGetDiagStatus;
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oGetDiagStatus);
}

/********************************************************************************
 * FUNCTION: vHandleSoundSystemConfig()
 *
 * DESCRIPTION:  Reading the Sound System Configuration data
 *
 * PARAMETER:   PO_MessageConfig::enID MsgId
 *
 * RETURNVALUE:  None
 *******************************************************************************/
void fc_audiomanager_tclSpeaker_Diagnosis::vHandleSoundSystemConfig(PO_MessageConfig::enID MsgId)
{
  const IDSetSoundSystemConfig* pMsg = pPO->POMessages->QueryMessage<IDSetSoundSystemConfig>(MsgId);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
  ETG_TRACE_USR4(("SpeakerDiagnosis: IDSetSoundSystemConfig received:%d",pMsg->u8SoundConfig));
  m_u8SoundSystemconfig = pMsg->u8SoundConfig;
}



