/*******************************************************************************
* FILE:          fc_audiomanager_Microphone_Diagnosis.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager microphone diagnosis
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Microphone diagnosis.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 22.03.13  | Tino Lippold            | Inital version
*******************************************************************************/

#ifndef FC_AUDIOMANAGER_MICROPHONE_DIAGNOSIS_H_
#define FC_AUDIOMANAGER_MICROPHONE_DIAGNOSIS_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
// already included --- #include "../InternalComponentCommunication/InternalCommunicationAdapter.h"


/******************************************************************************/
/*                                                                            */
/* FORWARD DECLARATION                                                        */
/*                                                                            */
/******************************************************************************/
class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_audiomanager_tclMicrophone_Diagnosis: public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   fc_audiomanager_tclMicrophone_Diagnosis(fc_audiomanager_tclApp * poMain, fc_audiomanager_tclService_Audio_Function * poService);
   fc_audiomanager_tclMicrophone_Diagnosis();
   virtual ~fc_audiomanager_tclMicrophone_Diagnosis();
   tBool bSendMicrophoneConnectionStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tVoid vOpenMicDevice(OSAL_tIODescriptor * phHandle, tCString cszDevice) const;
   tVoid vCloseMicDevice(OSAL_tIODescriptor * phHandle, tCString cszDevice) const;
   tU16 u16GetMicCurrent(tVoid);
   tU16 u16GetMicUBatHalf(tVoid);
   tU16 u16GetMicAdcValue(OSAL_tIODescriptor hHandle) const;
   tVoid vReadMicrophoneCurrent(tVoid);
   tVoid vEnterAppStateNormal(tVoid);
   tVoid vLeaveAppStateNormal(tVoid);
   tVoid vEnterVoltageStateNormal(tVoid);
   tVoid vLeaveVoltageStateNormal(tVoid);
   tVoid vProcessTimer(tVoid);
   tVoid vAddObserver(tVoid);
   virtual tVoid MessageNotification(PO_MessageConfig::enID MsgId);

   tS32 getADCmVoltage(tCString cszDevice);
   tS8  s8GetGPIOState(OSAL_enGpioPins GPIO_ID);
   tVoid vMakeMicDiagJAC();
   tVoid vMakeMicDiagSUZ();
   tVoid vMakeMicDiagPSA();
   tVoid vMakeMicDiagVAG();

private:
   fc_audiomanager_tclApp * m_poMainApp;
   fc_audiomanager_tclService_Audio_Function * m_poAudioService;
   tBool m_bRetVal;
   tU16 m_u16MicrophoneCurrent;
   tU8 m_u8MicrophoneConnectionStatus;
   tU8 m_u8MicrophoneDetection;
   tBool m_bNormalAppState;
   tBool m_bNormalVoltageState;
   tBool m_bTimerStarted;
   OSAL_tIODescriptor m_hMicCurrentDiagHandle;  // for measuring the mic current (MIC_VCC_DIAG)
   OSAL_tIODescriptor m_hMicUBatHalfDiagHandle; // for measuring the U(BAT)/2 (MIC_DIAG)

};

#endif /* FC_AUDIOMANAGER_MICROPHONE_DIAGNOSIS_H_ */
