/*******************************************************************************
* FILE:          fc_audiomanager_DiaglogClientHandler_Temp.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   ClientHandler for the service of the Diaglog Diagnosis
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

#ifndef _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_TEMP_H_
#define _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_TEMP_H_

#include "fc_audiomanager_main.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3DiagType.h"

#include "InternalCommunicationAdapter.h"
#include "Messages/Diag/ID_CCA_GetDiagResult.h"

/*TEST
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"
#include "../InternalComponentCommunication/Observer/Diag/DiagDefSetObserver.h"
TEST*/

/*******************************************************************************
                  fc_audiomanager ClientHandler for Diagnosis
*******************************************************************************/

class tclDiagDefSet;/*TEST*/

class fc_audiomanager_tclDiagResultMsg;

class fc_audiomanager_tclDiaglogClientHandler_Amplifier
      : public IF_MessageObserver<PO_MessageConfig::enID>
{

public:
   /****************************************************************************
   ** FUNCTION:   fc_audiomanager_tclDiaglogClientHandler_Amplifier(tVoid);
   ****************************************************************************/
   /* DESCRIPTION:   Default Constructor
   *
   *   NOTE: Default Constructor will not be implemented.
   *   Avoids Lint Prio 3 warning: Info 1712: default constructor not defined
   *   for class 'fc_audiomanager_tclDiaglogClientHandler_Amplifier'
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Amplifier(tVoid);


   /****************************************************************************
   ** FUNCTION:
   * fc_audiomanager_tclDiaglogClientHandler_Amplifier(fc_streamrouter_tclApp* pMainAppl);
   ****************************************************************************/
   /* DESCRIPTION:   Constructor
   *
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Amplifier(fc_audiomanager_tclApp* poMainAppl);

   /****************************************************************************
   ** FUNCTION:   virtual ~fc_audiomanager_tclDiaglogClientHandler_Amplifier();
   ****************************************************************************/
   /* DESCRIPTION:   Destructor
   *
   ****************************************************************************/
   virtual ~fc_audiomanager_tclDiaglogClientHandler_Amplifier();

/*TEST
virtual tVoid DiagDefSetProcess(tenDiagDefSetType enDiagDefSetType, tenDiagDefSetPhase enDiagDefSetPhase);
TEST*/

   /****************************************************************************
   ** FUNCTION:
   *   fc_audiomanager_tclDiaglogClientHandler_Amplifier& operator=
   *      (const fc_audiomanager_tclDiaglogClientHandler_Amplifier &oClientHandler);
   ****************************************************************************/
   /* DESCRIPTION:   Assignment Operator
   *
   *   NOTE: Assingment operater, will not be implemented.
   *   - Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   *     'fc_audiomanager_tclDiaglogClientHandler_Amplifier' which has no assignment operator.
   *   - Disables the assignment operator for this class. So if an attempt for
   *     the assignment is made the compiler complains.
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Amplifier& operator=
      (const fc_audiomanager_tclDiaglogClientHandler_Amplifier &oClientHandler);


//   /****************************************************************************
//                   implement IF_MessageObserver
//   ****************************************************************************/

   virtual void MessageNotification(PO_MessageConfig::enID msgID);

   /****************************************************************************
                  Specific Functions of this class
   ****************************************************************************/
private:

    tVoid vSaveTestResult(tU16 u16TroubleCode, tS16 sResult);

    tVoid vSendTestResultToDiaglog(tVoid);

public:
    tVoid vSend_AmpTempResultToDiaglog(tenErrorSite enErrorSite, tenErrorCode enErrorCode, tenErrorValue enErrorValue) const;


   /****************************************************************************
                  Member variables of this class
   ****************************************************************************/
private:
  // Create the data object for result list
  tTestResultList oFiTestResultObject;

  //only at the beginning if the service is available send the TestResult to the diagnosis
    //and if the NextTestResult Method is coming
    tBool bSendNextTestResult_AmpTemp;


    tS16 enLastAmpTempResult;

    // Address of the component handling CCA-communication with vd_diaglog,
    // usually fc_audiomanager_clienthandler_DiagLog.
    // (initialized from PO-message ID_CCA_GetDiagResult)
    IF_DiagResultHandler* poResultHandler;

    fc_audiomanager_tclApp* m_poMainAppl;
};

#endif // _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_TEMP_H_
