/*******************************************************************************
* FILE:          fc_audiomanager_DiaglogClientHandler_Speaker.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   ClientHandler for the service of the Diaglog Diagnosis
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2014 RBEI
* HISTORY:
* Date      | Author                  | Modification
* 3.3.14  | Puneeth | Inital version
*******************************************************************************/

#ifndef _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_SPEAKER_H_
#define _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_SPEAKER_H_

/* Include Diagnostics FI interface */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "fc_audiomanager_main.h"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/ADR3DiagType.h"
#include "../InternalComponentCommunication/Messages/Diag/IDNotifyDiagResult.h"
#include "../InternalComponentCommunication/Messages/Diag/ID_CCA_GetDiagResult.h"




/*******************************************************************************
                  fc_audiomanager ClientHandler for Diagnosis
*******************************************************************************/

class fc_audiomanager_tclApp;

class fc_audiomanager_tclDiaglogClientHandler_Speaker
      : public IF_MessageObserver<PO_MessageConfig::enID>
{

public:
   /****************************************************************************
   ** FUNCTION:   fc_audiomanager_tclDiaglogClientHandler_Speaker(tVoid);
   ****************************************************************************/
   /* DESCRIPTION:   Default Constructor
   *
   *   NOTE: Default Constructor will not be implemented.
   *   Avoids Lint Prio 3 warning: Info 1712: default constructor not defined
   *   for class 'fc_audiomanager_tclDiaglogClientHandler_Amplifier'
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Speaker(tVoid);


   /****************************************************************************
   ** FUNCTION:
   * fc_audiomanager_tclDiaglogClientHandler_Speaker(fc_streamrouter_tclApp* pMainAppl);
   ****************************************************************************/
   /* DESCRIPTION:   Constructor
   *
   ****************************************************************************/
  fc_audiomanager_tclDiaglogClientHandler_Speaker(fc_audiomanager_tclApp* poMainAppl);

   /****************************************************************************
   ** FUNCTION:   virtual ~fc_audiomanager_tclDiaglogClientHandler_Speaker();
   ****************************************************************************/
   /* DESCRIPTION:   Destructor
   *
   ****************************************************************************/
   virtual ~fc_audiomanager_tclDiaglogClientHandler_Speaker();

   /****************************************************************************
   ** FUNCTION:
   *   fc_audiomanager_tclDiaglogClientHandler_Speaker& operator=
   *      (const fc_audiomanager_tclDiaglogClientHandler_Speaker &oClientHandler);
   ****************************************************************************/
   /* DESCRIPTION:   Assignment Operator
   *
   *   NOTE: Assingment operater, will not be implemented.
   *   - Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   *     'fc_audiomanager_tclDiaglogClientHandler_Speaker' which has no assignment operator.
   *   - Disables the assignment operator for this class. So if an attempt for
   *     the assignment is made the compiler complains.
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Speaker& operator=
      (const fc_audiomanager_tclDiaglogClientHandler_Speaker &oClientHandler);

   /****************************************************************************
                  Overriding of general CCA methods
   ****************************************************************************/

   /****************************************************************************
                  Overridng of CCA Extension methods
   ****************************************************************************/

   /****************************************************************************
   **              Declare Message Map
   ****************************************************************************/
   /* DESCRIPTION:
   *   The message map is used to "redirect" incoming FI messages to
   *   dedicated handler functions
   ****************************************************************************/
   InternalCommunicationAdapter* m_pPO; // Pointer for post office access

   void vAddObserver();
   virtual void MessageNotification(PO_MessageConfig::enID MsgId);

private:


   /****************************************************************************
                  Specific Functions of this class
   ****************************************************************************/
  tVoid vCheckErrorCodeSpeakerLf(tenErrorCode enErrorCode);
  tVoid vCheckErrorCodeSpeakerRf(tenErrorCode enErrorCode);
  tVoid vCheckErrorCodeSpeakerLr(tenErrorCode enErrorCode);
  tVoid vCheckErrorCodeSpeakerRr(tenErrorCode enErrorCode);
  tVoid vCheckErrorSite(tenErrorSite enErrorSite, tenErrorCode enErrorCode);
  tVoid vSaveTestResult(tU16 u16troublecode, tS16 sresult);
  tVoid vSendTestResultToDiaglog(tVoid);

   /****************************************************************************
                  Handler Functions for incoming FI messages
   ****************************************************************************/



public:

  tVoid vSendSpeakerResultToDiaglog(tenErrorSite enErrorSite, tenErrorCode enErrorCode, tenErrorValue enErrorValue) ;

   /****************************************************************************
                  Member variables of this class
   ****************************************************************************/
private:

  static fc_audiomanager_tclApp *m_poCcaMainApp;

  tU16 m_u16TroubleCode;

  tS16 m_sResult;

  tU8 m_u8DiagRemoteControlPhase;
  tBool m_bActiveSinkSet;
  IF_DiagResultHandler* m_poResultHandler;
  // Create the data object for result list
  tTestResultList m_oFiTestResultObject;
};

#endif // _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_SPEAKER_H_
