/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_LinearMode.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler implements the Linear Mode of the Diagnosis.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 20.12.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "fc_audiomanager_DiaglibHandler_LinearMode.h"
#include "../InternalComponentCommunication/DataTypes/TypeDefines/DiagLinearModeType.h"
#include "../../PostOffice/PostOffice.hpp"
#include "../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../InternalComponentCommunication/Messages/Diag/IDDiagLinearMode.h"


#include "fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_DiaglibHandler_LinearMode.cpp.trc.h"
#endif



/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_tclDiaglibHandler_LinearMode(
*                                    diaglib::tclServiceDiaglib* pDiaglibService)
*                                    : mpDiaglibService(pDiaglibService)
*   Constructor
*******************************************************************************/

fc_audiomanager_tclDiaglibHandler_LinearMode::fc_audiomanager_tclDiaglibHandler_LinearMode(
                                      diaglib::tclServiceDiaglib* pDiaglibService)
                                        : mpDiaglibService(pDiaglibService)
{
#ifdef IOCONTROLID_AUDIO_LINEAR_MODE
   if(mpDiaglibService != NULL)
   {
      mpDiaglibService->poGetIoCtrl()->vRegisterListener(IOCONTROLID_AUDIO_LINEAR_MODE, this);
      ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode => vRegisterListener(IOCONTROLID_AUDIO_LINEAR_MODE) "));
   }
   else
   {
      ETG_TRACE_FATAL(( "fc_audiomanager_tclDiaglibHandler_LinearMode constructor: diaglib pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
   }

#endif
}



/*******************************************************************************
**  FUNCTION:
*   ~fc_audiomanager_tclDiaglibHandler_LinearMode()
*   Destructor
*******************************************************************************/
fc_audiomanager_tclDiaglibHandler_LinearMode::~fc_audiomanager_tclDiaglibHandler_LinearMode()
{
   mpDiaglibService = NULL;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControl(tU32 u32IoControlId, diaglib::tenIoControlAction enActionId,
*                 const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for set Phantom Voltage request
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl (
                                                             tU32 u32IoControlId,
                                                             diaglib::tenIoControlAction enActionId,
                                                             const diaglib::tclParameterVector& oParameterVector,
                                                             diaglib::tContext MsgContext
                                                           )
{
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl entered"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_NOT_OK;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( enActionId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParameterVector )
   // check for expected Routine ID
#ifdef IOCONTROLID_AUDIO_LINEAR_MODE
   switch(u32IoControlId)
   {

   case IOCONTROLID_AUDIO_LINEAR_MODE:
      {
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => IOCONTROLID_AUDIO_LINEAR_MODE"));

         // create object for response
         diaglib::tclParameterVector oTmpVec;

         // answer beginn

         if(diaglib::bCheckParameterSignature(oParameterVector,
                                              IOCONTROLID_AUDIO_LINEAR_MODE_SET_LEN,
                                              IOCONTROLID_AUDIO_LINEAR_MODE_SET_PARAM1) == FALSE)
         {
            ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => ERROR: bCheckParameterSignature FAILED"));
            oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

            diaglib::trParameter paramaError;
            paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
            paramaError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
            oTmpVec.push_back(paramaError);
         }// if(diaglib::bCheckParameterSignature(oParamVector, ...
         else
         {
             // get Data
             tBool bMode = oParameterVector[IOCONTROLID_AUDIO_LINEAR_MODE_SET_bMode].u8Value; //1=enable, 0=dissable

             //Send the DiagLinearMode Message to all fc_audimanager subcomponents
             //ID_DiagLinearMode DiagLinearModeMsg(tenDiagLinearModePhase(EN_LINEARMODE_SET));
             if (bMode)//1=enable
             {
                 ID_DiagLinearMode DiagLinearModeMsg(EN_LINEARMODE_SET);
                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagLinearModeMsg);
                 ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => DeliverMsg(ID_DiagLinearMode(EN_LINEARMODE_SET)) is sent"));
             }
             else //0=dissable
             {
                 ID_DiagLinearMode DiagLinearModeMsg(EN_LINEARMODE_UNFREEZE);
                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagLinearModeMsg);
                 ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => bMode is dissable DeliverMsg(ID_DiagLinearMode(EN_LINEARMODE_UNFREEZE)) is sent"));
             }


             oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid
             diaglib::trParameter paramaStatus;
             paramaStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_AUDIO_LINEAR_MODE_RESULT_PARAM1);
             paramaStatus.u8Value        = bMode;
             oTmpVec.push_back(paramaStatus);

         }



         // send message back to diagnosis
         if(mpDiaglibService != OSAL_NULL)
         {
            if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlMethodResult( oCtrlResult,
                                                                                 enActionId,
                                                                                 oTmpVec,
                                                                                 MsgContext) )
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
               ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => bSendIoCtrlMethodResult successfull"));
            }// if(TRUE == mpDiaglibService->poGetIoCtrl()
            else
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
               ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => ERROR : bSendRoutineCtrlMethodResult failed"));
            }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
         }// if(mpDiaglibService != OSAL_NULL)
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => ERROR : mpDiaglibService == OSAL_NULL"));
         }// else // if(mpDiaglibService != OSAL_NULL)
         break;

      }// case IOCONTROLID_AUDIO_LINEAR_MODE:

      default:
      {
         break;
      }// default:
   }// switch(u32IoControlId)
#endif
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl(%x)",u32Return));
   ETG_TRACE_USR3(("---oCtrlResult = %d ",oCtrlResult));
   ETG_TRACE_USR3(("---u32IoControlId = %d ",u32IoControlId));
   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlFreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Freeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlFreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlFreeze"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   //Send the DiagLinearMode Message to all fc_audimanager subcomponents
   ID_DiagLinearMode DiagLinearModeMsg(EN_LINEARMODE_FREEZE);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagLinearModeMsg);
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => DeliverMsg(ID_DiagLinearMode(EN_LINEARMODE_FREEZE)) is sent"));

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlFreezeResult( oCtrlResult,
                                                                           MsgContext) )
      {

         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlFreeze => bSendIoCtrlFreezeResult successfull"));

      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlFreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlFreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlFreeze(%x)",u32Return));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlUnfreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Unfreeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlUnfreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlUnfreeze"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   //Send the DiagLinearMode Message to all fc_audimanager subcomponents
   ID_DiagLinearMode DiagLinearModeMsg(EN_LINEARMODE_UNFREEZE);

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControl => DeliverMsg(ID_DiagLinearMode(EN_LINEARMODE_UNFREEZE)) is sent"));
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagLinearModeMsg);

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlUnfreezeResult( oCtrlResult,
                                                                                MsgContext) )
      {

         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlUnfreeze => bSendIoCtrlFreezeResult successfull"));

      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlUnfreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlUnfreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR3(("fc_audiomanager_tclDiaglibHandler_LinearMode::vOnIoControlUnfreeze(%x)",u32Return));
   return u32Return;

}


