/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_DefSet.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a system set listener.
* This handler sets the audio values used for IncreaseDecrease audio
* back to default on a DefSet request.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef FC_AUDIOMANAGER_DIAGLIBHANDLER_DEFSET_H
#define FC_AUDIOMANAGER_DIAGLIBHANDLER_DEFSET_H


/**
 * Message are received by implementing ListenerInterfaces and registering
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */
// +++ Adjust class prefix +++
class fc_audiomanager_tclDiaglibHandler_DefSet: public diaglib::tclSystemSetListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_audiomanager_tclDiaglibHandler_DefSet(diaglib::tclServiceDiaglib* pDiaglibService);
   virtual ~fc_audiomanager_tclDiaglibHandler_DefSet();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * SystemSetListener methods
    ***************************************************************************/
   virtual tU32 vOnSystemSet (
                               tU32 u32SystemSetID,
                               diaglib::tenSystemSetType u32SystemSetType,
                               diaglib::tContext MsgContext
                             );

  virtual tU32 vOnSystemSetFinished (
                                       tU32 u32SystemSetID,
                                       diaglib::tenSystemSetType u32SystemSetType,
                                       diaglib::tContext MsgContext
                                     );

  virtual tU32 vOnSystemSetPrepare (
                                       tU32 u32SystemSetID,
                                       diaglib::tenSystemSetType u32SystemSetType,
                                       diaglib::tContext MsgContext
                                    );

  virtual tU32 vOnSystemSetCheck (
                                    tU32 u32SystemSetID,
                                    diaglib::tenSystemSetType u32SystemSetType,
                                    diaglib::tContext MsgContext
                                   );
private:
   diaglib::tclServiceDiaglib* mpDiaglibService;

   fc_audiomanager_tclDiaglibHandler_DefSet();//lint !e1704 Info 1704 , eliminating lint warnings

};
#endif // FC_AUDIOMANAGER_DIAGLIBHANDLAER_DEFSET_H
