/*******************************************************************************
* FILE:          fc_audiomanager_DiaglibHandler_ActiveSink.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of a IOControl listener.
* This handler sets the Audio Sink Active in Diagnosis Remote control Mode.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 1.7.16  | pmh7kor          | Inital version
*******************************************************************************/

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef FC_AUDIOMANAGER_DIAGLIBHANDLER_ACTIVESINK_H
#define FC_AUDIOMANAGER_DIAGLIBHANDLER_ACTIVESINK_H


/**
 * Message are received by implementing ListenerInterfaces and registering
 * them with diagnosis library. Active sink is handled in this class.
 */
// +++ Adjust class prefix +++
class fc_audiomanager_DiaglibHandler_ActiveSink: public diaglib::tclIoControlListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_audiomanager_DiaglibHandler_ActiveSink(diaglib::tclServiceDiaglib*   pDiaglibService);
   virtual ~fc_audiomanager_DiaglibHandler_ActiveSink();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * RoutineControl methods
    ***************************************************************************/
  virtual tU32 vOnIoControl (
                               tU32 u32IoControlId,
                               diaglib::tenIoControlAction enActionId,
                               const diaglib::tclParameterVector& oParameterVector,
                               diaglib::tContext MsgContext
                             );
   virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     diaglib::tContext MsgContext
                                   );

   virtual tU32 vOnIoControlUnfreeze (
                                        tU32 u32IoControlId,
                                        diaglib::tContext MsgContext
                                      );

private:
  diaglib::tclServiceDiaglib*  mpDiaglibService;

  fc_audiomanager_DiaglibHandler_ActiveSink();
};
#endif // FC_AUDIOMANAGER_DIAGLIBHANDLER_ACTIVESINK_H
