/*******************************************************************************
* FILE:          fc_audiomanager_Audio_Diagnosis.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager Diagnosis
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Common Diagnosis class to generate all the Diagnosis classes
*                for Diaglib and Diaglog. It is not separate Service Diagnosis FI.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/

#ifndef _FC_AUDIOMANAGER_AUDIO_DIAGNOSIS_H_
#define _FC_AUDIOMANAGER_AUDIO_DIAGNOSIS_H_


//DIAGLIB beginn
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"
//DIAGLIB end

#include "fc_audiomanager_DiaglogClientHandler_Temp.h"
#include "fc_audiomanager_DiaglogClientHandler_Speaker.h"
//Because is needed in the "fc_audiomanager_main.cpp" for the timer function
// through fc_audiomanger_Audio_Diagnosis.h

/* DIAGLIB beginn */
//class diaglib::tclServiceDiaglib;
class fc_audiomanager_tclDiaglibHandler_DefSet;
class fc_audiomanager_tclDiaglibHandler_AudioGain;
class fc_audiomanager_tclDiaglibHandler_LinearMode;
class fc_audiomanager_tclDiaglibHandler_RemoteControl;
class fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine;
class fc_audiomanager_DiaglibHandler_AudioSettings;
class fc_audiomanager_DiaglibHandler_ActiveSink;
class fc_audiomanager_tclDiaglibHandler_Buzzer;
/* DIAGLIB end */

/* DIAGLOG beginn */
class fc_audiomanager_tclDiaglogClientHandler_Amplifier;
class fc_audiomanager_tclDiaglogClientHandler_Speaker;
/* DIAGLOG end */

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
class fc_audiomanager_tclDiaglibHandler_BoseAmplifier;
class fc_audiomanager_tclDiaglogClientHandler_ANCASCSelfDiagnosis;
class fc_audiomanager_tclDiaglogClientHandler_SpeakerSelfDiagnosis;
class fc_audiomanager_tclDiaglogBoseCommunicationError;
#endif

/*******************************************************************************
                  FC_Audiomanager for Diagnosis
*******************************************************************************/

class fc_audiomanager_tclAudio_Diagnosis
{

public:
   /****************************************************************************
   ** FUNCTION:   fc_audiomanager_tclAudio_Diagnosis(fc_audiomanager_tclApp* poMainAppl);
   ****************************************************************************/
   /* DESCRIPTION:   Default Constructor
   *
   ****************************************************************************/
   fc_audiomanager_tclAudio_Diagnosis(fc_audiomanager_tclApp* poMainAppl);


   /****************************************************************************
   ** FUNCTION:   virtual ~fc_audiomanager_tclAudio_Diagnosis();
   ****************************************************************************/
   /* DESCRIPTION:   Destructor
   *
   ****************************************************************************/
   virtual ~fc_audiomanager_tclAudio_Diagnosis(tVoid);

    /* DIAGLIB beginn */
  diaglib::tclServiceDiaglib*                    m_pDiaglibService;
  fc_audiomanager_tclDiaglibHandler_DefSet*              m_pDiaglibHandler_DefSet;
  fc_audiomanager_tclDiaglibHandler_AudioGain*          m_pDiaglibHandler_AudioGain;
  fc_audiomanager_tclDiaglibHandler_LinearMode*          m_pDiaglibHandler_LinearMode;
  fc_audiomanager_tclDiaglibHandler_RemoteControl*      m_pDiaglibHandler_RemoteControl;
  fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine*  m_pDiaglibHandler_ExtAmpControlLine;
  fc_audiomanager_DiaglibHandler_AudioSettings*         m_pDiaglibHandler_AudioSettings;
  fc_audiomanager_DiaglibHandler_ActiveSink*      m_pDiaglibHandler_ActiveSink;
  fc_audiomanager_tclDiaglibHandler_Buzzer*             m_pDiaglibHandler_Buzzer;
  /* DIAGLIB end */

  /* DIAGLOG beginn */
  fc_audiomanager_tclDiaglogClientHandler_Amplifier*  m_pDiaglogClientHandler_Amplifier;
  fc_audiomanager_tclDiaglogClientHandler_Speaker*  m_pDiaglogClientHandler_Speaker;
  /* DIAGLOG end */

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
 fc_audiomanager_tclDiaglogClientHandler_ANCASCSelfDiagnosis * m_pDiaglogClientHandler_ANCASCSelfDiagnosis;
 fc_audiomanager_tclDiaglibHandler_BoseAmplifier * m_pDiaglibHandler_BoseAmplifier;
 fc_audiomanager_tclDiaglogClientHandler_SpeakerSelfDiagnosis *m_pDiaglogClientHandler_SpeakerSelfDiagnosis;
 fc_audiomanager_tclDiaglogBoseCommunicationError* m_pDiaglogClientHandler_BoseCommError;
#endif

};

#endif // _FC_AUDIOMANAGER_AUDIO_DIAGNOSIS_H_
