/*******************************************************************************
* FILE:          fc_audiomanager_Audio_Diagnosis.cpp
* PROJECT:
* SW-COMPONENT:  fc_audiomanager Diagnosis
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Common Diagnosis class to generate all the Diagnosis classes
*                for Diaglib and Diaglog. It is not separate Service Diagnosis FI.
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 27.09.12  | SoftTec Gaidatzi-Lken  | Inital version
*******************************************************************************/
#include "fc_audiomanager_main.h"
#include "fc_audiomanager_Audio_Diagnosis.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_AUDIO_DIAGNOSIS
#include "trcGenProj/Header/fc_audiomanager_Audio_Diagnosis.cpp.trc.h"
#endif


/* DIAGLIB beginn */
#include "fc_audiomanager_DiaglibHandler_DefSet.h"
#include "fc_audiomanager_DiaglibHandler_AudioGain.h"
#include "fc_audiomanager_DiaglibHandler_LinearMode.h"
#include "fc_audiomanager_DiaglibHandler_RemoteControl.h"
#include "fc_audiomanager_DiaglibHandler_ExtAmpControlLine.h"
#include "fc_audiomanager_DiaglibHandler_AudioSetting.h"
#include "fc_audiomanager_DiaglibHandler_ActiveSink.h"
#include "fc_audiomanager_DiaglibHandler_Buzzer.h"
/* DIAGLIB end */


/* DIAGLOG beginn */
//#include "fc_audiomanager_DiaglogClientHandler_Temp.h" //This is already in Header file included
/* DIAGLOG end */

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#include "fc_audiomanager_DiaglibHandler_BoseAmplifier.h"
#include "fc_audiomanager_DiaglogClientHandler_ANCASCSelfDiag.h"
#include "fc_audiomanager_DiaglogClientHandler_SpeakerSelfDiag.h"
#include "fc_audiomanager_DiaglogClientHandler_BoseCommError.h"
#endif


/*******************************************************************************
                  Methods of class
*******************************************************************************/

/*******************************************************************************
**  FUNCTION:
*   fc_audiomanager_tclAudio_Diagnosis(fc_audiomanager_tclApp* poMainAppl)
*   Constructor
*******************************************************************************/
fc_audiomanager_tclAudio_Diagnosis::fc_audiomanager_tclAudio_Diagnosis(fc_audiomanager_tclApp* poMainAppl)
{

  /* DIAGLIB beginn */
  m_pDiaglibService = NULL;
  m_pDiaglibHandler_DefSet = NULL;
  m_pDiaglibHandler_AudioGain = NULL;
  m_pDiaglibHandler_LinearMode = NULL;
  m_pDiaglibHandler_RemoteControl = NULL;
  m_pDiaglibHandler_ExtAmpControlLine = NULL;
  m_pDiaglibHandler_AudioSettings = NULL;
  m_pDiaglibHandler_ActiveSink = NULL;
  m_pDiaglibHandler_Buzzer = NULL;
  m_pDiaglogClientHandler_Speaker = NULL; //coverity warning fix
  m_pDiaglogClientHandler_Amplifier = NULL;


  if (poMainAppl == NULL)
  {
      ETG_TRACE_FATAL(( "bOnInit: FC_Audiomanager pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
      return;
  }

  // Generate Diaglib Framework
  m_pDiaglibService = OSAL_NEW diaglib::tclServiceDiaglib((ahl_tclBaseOneThreadApp*)poMainAppl, 1);
  if (m_pDiaglibService == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib service failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }

   // Generate "Default Settings handler" for Diaglib IF (diagnosis)
   m_pDiaglibHandler_DefSet = OSAL_NEW fc_audiomanager_tclDiaglibHandler_DefSet(m_pDiaglibService);
   if (m_pDiaglibHandler_DefSet == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Default Settings handler handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#ifdef IOCONTROLID_AUDIO_GAIN
   // Generate "Audio Gain handler" for Diaglib IF (diagnosis)
   m_pDiaglibHandler_AudioGain = OSAL_NEW fc_audiomanager_tclDiaglibHandler_AudioGain(m_pDiaglibService);
   if (m_pDiaglibHandler_AudioGain == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Audio Gain handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif

#if defined(IOCONTROLID_AUDIO_BALANCE) || defined(IOCONTROLID_AUDIO_FADER)
   // Generate "Audio Gain handler" for Diaglib IF (diagnosis)
    ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Audio SETTINGS handler for diagnosis" ));
   m_pDiaglibHandler_AudioSettings = OSAL_NEW fc_audiomanager_DiaglibHandler_AudioSettings(m_pDiaglibService);
   if (m_pDiaglibHandler_AudioSettings == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Audio SETTINGS handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif

#ifdef IOCONTROLID_AUDIO_LINEAR_MODE
   // Generate "Linear Mode handler" for Diaglib IF (diagnosis)
   m_pDiaglibHandler_LinearMode = OSAL_NEW fc_audiomanager_tclDiaglibHandler_LinearMode(m_pDiaglibService);
   if (m_pDiaglibHandler_LinearMode == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Linear Mode handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif
#ifdef IOCONTROLID_DIAG_REMOTE_CONTROL
   // Generate "Remote Control handler" for Diaglib IF (diagnosis)
   m_pDiaglibHandler_RemoteControl = OSAL_NEW fc_audiomanager_tclDiaglibHandler_RemoteControl(m_pDiaglibService);
   if (m_pDiaglibHandler_RemoteControl == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Remote Control handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif

#ifdef IOCONTROLID_AUDIO_EXT_AMPLIFIER
   // Generate "External Amplifier ControlLine handler" for Diaglib IF (diagnosis)
   m_pDiaglibHandler_ExtAmpControlLine = OSAL_NEW fc_audiomanager_tclDiaglibHandler_ExtAmpControlLine(m_pDiaglibService);
   if (m_pDiaglibHandler_ExtAmpControlLine == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib ExtAmpControlLine handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif
   /* DIAGLIB end */
#ifdef IOCONTROLID_AUDIO_ACTIVE_SINK
   m_pDiaglibHandler_ActiveSink = OSAL_NEW fc_audiomanager_DiaglibHandler_ActiveSink(m_pDiaglibService);
   if (m_pDiaglibHandler_ActiveSink == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Audio Active Sink handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif

   /* DIAGLOG beginn */

   // delete "Amplifier clientHandler" for Diaglog IF
   // (internal Amplifier Tempereture DTC and external Amplifier Control Line DTC)
   //
   m_pDiaglogClientHandler_Amplifier = OSAL_NEW fc_audiomanager_tclDiaglogClientHandler_Amplifier(poMainAppl);
   if (m_pDiaglogClientHandler_Amplifier == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglog ClientHandler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }

   m_pDiaglogClientHandler_Speaker = OSAL_NEW fc_audiomanager_tclDiaglogClientHandler_Speaker(poMainAppl);
   if (m_pDiaglogClientHandler_Speaker == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglog ClientHandler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
  /* DIAGLOG end */

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI

   m_pDiaglibHandler_BoseAmplifier = NULL;
   m_pDiaglibHandler_BoseAmplifier = OSAL_NEW fc_audiomanager_tclDiaglibHandler_BoseAmplifier(m_pDiaglibService);
   if (m_pDiaglibHandler_BoseAmplifier == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diag lib handler for bose amplifier failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
   m_pDiaglogClientHandler_ANCASCSelfDiagnosis = NULL;
   m_pDiaglogClientHandler_ANCASCSelfDiagnosis = OSAL_NEW fc_audiomanager_tclDiaglogClientHandler_ANCASCSelfDiagnosis(poMainAppl);
   if (m_pDiaglogClientHandler_ANCASCSelfDiagnosis == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglog ClientHandler for ANC ASC diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
   m_pDiaglogClientHandler_SpeakerSelfDiagnosis = NULL;
   m_pDiaglogClientHandler_SpeakerSelfDiagnosis = OSAL_NEW fc_audiomanager_tclDiaglogClientHandler_SpeakerSelfDiagnosis(poMainAppl);
   if (m_pDiaglogClientHandler_SpeakerSelfDiagnosis == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglog ClientHandler for speaker diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
   m_pDiaglogClientHandler_BoseCommError = NULL;
   m_pDiaglogClientHandler_BoseCommError = OSAL_NEW fc_audiomanager_tclDiaglogBoseCommunicationError(poMainAppl);
   if (m_pDiaglogClientHandler_BoseCommError == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglog clienthandler for bose amplifier comm error failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif

#ifdef IOCONTROLID_BUZZER_TEST_TONE
   m_pDiaglibHandler_Buzzer = OSAL_NEW fc_audiomanager_tclDiaglibHandler_Buzzer(m_pDiaglibService);
   if (m_pDiaglibHandler_Buzzer == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Buzzer handler for diagnosis failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
#endif
}


/*******************************************************************************
**  FUNCTION:
*   ~fc_audiomanager_tclAudio_Diagnosis(tVoid)
*   Destructor
*******************************************************************************/
fc_audiomanager_tclAudio_Diagnosis::~fc_audiomanager_tclAudio_Diagnosis(tVoid)
{
  /* DIAGLIB beginn */

  // delete Diaglib Framework
   if (m_pDiaglibService != NULL)
   {
    OSAL_DELETE m_pDiaglibService;
    m_pDiaglibService = NULL;
   }

   // delete "Default Settings handler" for diagnosis
   if (m_pDiaglibHandler_DefSet != NULL)
   {
     OSAL_DELETE m_pDiaglibHandler_DefSet;
     m_pDiaglibHandler_DefSet = NULL;
   }

   // delete "Audio Gain handler" for diagnosis
   if (m_pDiaglibHandler_AudioGain != NULL)
   {
    OSAL_DELETE m_pDiaglibHandler_AudioGain;
    m_pDiaglibHandler_AudioGain = NULL;
   }

   // delete "Linear Mode handler" for diagnosis
   if (m_pDiaglibHandler_LinearMode != NULL)
   {
    OSAL_DELETE m_pDiaglibHandler_LinearMode;
    m_pDiaglibHandler_LinearMode = NULL;
   }

   // delete "Remote Control handler" for diagnosis
   if (m_pDiaglibHandler_RemoteControl != NULL)
   {
    OSAL_DELETE m_pDiaglibHandler_RemoteControl;
    m_pDiaglibHandler_RemoteControl = NULL;
   }

   // delete "External Amplifier ControlLine handler" for diagnosis
   if (m_pDiaglibHandler_ExtAmpControlLine != NULL)
   {
    OSAL_DELETE m_pDiaglibHandler_ExtAmpControlLine;
    m_pDiaglibHandler_ExtAmpControlLine = NULL;
   }
   // delete "Balance and fader setting handler" for diagnosis
   if (m_pDiaglibHandler_AudioSettings != NULL)
   {
    OSAL_DELETE m_pDiaglibHandler_AudioSettings;
    m_pDiaglibHandler_AudioSettings = NULL;
   }
    // delete "Audio sink" for diagnosis
   if (m_pDiaglibHandler_ActiveSink != NULL)
   {
    OSAL_DELETE m_pDiaglibHandler_ActiveSink;
    m_pDiaglibHandler_ActiveSink = NULL;
   }

   /* DIAGLIB end */


   /* DIAGLOG beginn */

   // delete "Amplifier clientHandler" for Diaglog IF
   // (internal Amplifier Tempereture DTC and external Amplifier Control Line DTC)

   if (m_pDiaglogClientHandler_Amplifier != NULL)
   {
     OSAL_DELETE m_pDiaglogClientHandler_Amplifier;
     m_pDiaglogClientHandler_Amplifier = NULL;
   }

   if (m_pDiaglogClientHandler_Speaker != NULL)
   {
     OSAL_DELETE m_pDiaglogClientHandler_Speaker;
     m_pDiaglogClientHandler_Speaker = NULL;
   }
  /* DIAGLOG end */

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   if (m_pDiaglibHandler_BoseAmplifier != NULL)
   {
     OSAL_DELETE m_pDiaglibHandler_BoseAmplifier;
     m_pDiaglibHandler_BoseAmplifier = NULL;
   }
   if (m_pDiaglogClientHandler_ANCASCSelfDiagnosis != NULL)
   {
     OSAL_DELETE m_pDiaglogClientHandler_ANCASCSelfDiagnosis;
     m_pDiaglogClientHandler_ANCASCSelfDiagnosis = NULL;
   }
   if (m_pDiaglogClientHandler_SpeakerSelfDiagnosis != NULL)
   {
     OSAL_DELETE m_pDiaglogClientHandler_SpeakerSelfDiagnosis;
     m_pDiaglogClientHandler_SpeakerSelfDiagnosis = NULL;
   }

      if (m_pDiaglogClientHandler_BoseCommError != NULL)
   {
     OSAL_DELETE m_pDiaglogClientHandler_BoseCommError;
     m_pDiaglogClientHandler_BoseCommError = NULL;
   }
#endif

#ifdef IOCONTROLID_BUZZER_TEST_TONE
   if (m_pDiaglibHandler_Buzzer != NULL)
   {
      OSAL_DELETE m_pDiaglibHandler_Buzzer;
      m_pDiaglibHandler_Buzzer = NULL;
   }
#endif

}



