/*******************************************************************************
* FILE:          fc_audiomanager_Microphone_Diagnosis_main.h
* PROJECT:
* SW-COMPONENT:  Microphone Diagnosis in the FC_Audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Microphone diagnosis main class
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                            | Modification
* 09.02.15  | SoftTec Gaidatzi-Lken            | Inital version
*******************************************************************************/

#ifndef FC_AUDIOMANAGER_MICROPHONE_DIAGNOSIS_MAIN_H_
#define FC_AUDIOMANAGER_MICROPHONE_DIAGNOSIS_MAIN_H_


#define MAX_MIC 2 //Max of all projects, at the moment is 2 for PSA

/*
#if defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SUZUKI_LINUX
   #define MAX_MIC 1
#elif defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
   #define MAX_MIC 2
#elif defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   #define MAX_MIC 1
#elif defined VARIANT_S_FTR_ENABLE_FEAT_AUDIO_JAC_CII
   #define MAX_MIC 1
#else
    #define MAX_MIC 1
#endif
*/


/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"

#include "fc_audiomanager_Microphone.h"


//This include is for the oFiMicrophoneConnectionStatusObject variable
#include "../../fc_audiomanager_service_Audio_Function.h"

/******************************************************************************/
/*                                                                            */
/* FORWARD DECLARATION                                                        */
/*                                                                            */
/******************************************************************************/



/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;
class fc_audiomanager_tclMicrophone;
class fc_audiomanager_tclDiaglogClientHandler_Microphone;

class fc_audiomanager_tclMicrophone_Diagnosis: public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   fc_audiomanager_tclMicrophone_Diagnosis(fc_audiomanager_tclApp * poMain, fc_audiomanager_tclService_Audio_Function * poService);
   //fc_audiomanager_tclMicrophone_Diagnosis();
   virtual ~fc_audiomanager_tclMicrophone_Diagnosis();

   tVoid vProcessTimer(tVoid);
   tsMicData* ptsGetMicDataListElem(tU8 MicNr);

  /* *************************** Masc_fi Functions ***************************************/

   tBool bSendMicrophoneConnectionStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tVoid vAdaptMascfiMicStatus(tU8 MicNr);
   static tenMicState  m_tMicState[2];

private:
   tVoid vMakeMicDiag();
   tVoid vMakeMicDiagSUZ();
   tVoid vMakeMicDiagPSA();
   tVoid vMakeMicDiagAIVI();
   tVoid vMakeMicDiagCAF();
   tVoid vMakeMicDiagJAC();

   tVoid vGetMicConfig();


   /**** Functions to communicate with them fc_audiomanager, to get the spm states  *******/

   tVoid vAddObserver(tVoid);
   virtual tVoid MessageNotification(PO_MessageConfig::enID MsgId);
   tVoid vEnterAppStateNormal(tVoid);
   tVoid vLeaveAppStateNormal(tVoid);
   tVoid vEnterVoltageStateNormal(tVoid);
   tVoid vLeaveVoltageStateNormal(tVoid);

   fc_audiomanager_tclApp * m_poMainApp;
   fc_audiomanager_tclService_Audio_Function * m_poAudioService;
   fc_audiomanager_tclMicrophone * m_pMicrophone;
   fc_audiomanager_tclDiaglogClientHandler_Microphone * m_pDiaglogClientHandler_Microphone;
   //fc_audiomanager_tclDiaglibHandler_SetMicVoltage * m_pDiaglibHandler_SetMicVoltage;

   tsMicData MicDataList[MAX_MIC+1];

   tBool m_bNormalAppState;
   tBool m_bNormalVoltageState;
   tBool m_bTimerStarted;
   tBool bExistTestDataToSend;

   tU8 m_u8MicVal;

   // Create the (message related) masc_fi data object for the masc_fi property MicrophoneConnectionStatus
   midw_mascffi_tclMsgMicrophoneConnectionStatusStatus oFiMicrophoneConnectionStatusObject;

};

#endif /* FC_AUDIOMANAGER_MICROPHONE_DIAGNOSIS_MAIN_H_ */
