
/*******************************************************************************
* FILE:          fc_audiomanager_DiaglogClientHandler_Microphone.h
* PROJECT:
* SW-COMPONENT:  fc_audiomanager application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   ClientHandler for the service of the Diaglog
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                      | Modification
* 02.02.15  | SoftTec Gaidatzi-Lken      | Inital version
*******************************************************************************/

#ifndef _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_MICROPHONE_H_
#define _FC_AUDIOMANAGER_DIAGLOGCLIENTHANDLER_MICROPHONE_H_

/* Include Diagnostics FI interface
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"


#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

*/
#include "fc_audiomanager_Microphone_Diagnosis_main.h"


/*******************************************************************************
                  FC_audiomanager ClientHandler for Diagnostic
*******************************************************************************/
class fc_audiomanager_tclMicrophone_Diagnosis;

class ahl_tclBaseOneThreadClientHandler;

class fc_audiomanager_tclDiaglogClientHandler_Microphone
      : public IF_MessageObserver<PO_MessageConfig::enID>
{

public:
   /****************************************************************************
   ** FUNCTION:   fc_audiomanager_tclDiaglogClientHandler_Microphone(tVoid);
   ****************************************************************************/
   /* DESCRIPTION:   Default Constructor
   *
   *   NOTE: Default Constructor will not be implemented.
   *   Avoids Lint Prio 3 warning: Info 1712: default constructor not defined
   *   for class 'fc_audiomanager_tclDiaglogClientHandler_Microphone'
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Microphone(tVoid);


   /****************************************************************************
   ** FUNCTION:
   * fc_audiomanager_tclDiaglogClientHandler_Microphone(fc_streamrouter_tclApp* pMainAppl);
   ****************************************************************************/
   /* DESCRIPTION:   Constructor
   *
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Microphone(fc_audiomanager_tclMicrophone_Diagnosis* pMainMicDiagApp);

   /****************************************************************************
   ** FUNCTION:   virtual ~fc_audiomanager_tclDiaglogClientHandler_Microphone();
   ****************************************************************************/
   /* DESCRIPTION:   Destructor
   *
   ****************************************************************************/
   virtual ~fc_audiomanager_tclDiaglogClientHandler_Microphone();


   /****************************************************************************
   ** FUNCTION:
   *   fc_audiomanager_tclDiaglogClientHandler_Microphone& operator=
   *      (const fc_audiomanager_tclDiaglogClientHandler_Microphone &oClientHandler);
   ****************************************************************************/
   /* DESCRIPTION:   Assignment Operator
   *
   *   NOTE: Assingment operater, will not be implemented.
   *   - Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   *     'fc_audiomanager_tclDiaglogClientHandler_Microphone' which has no assignment operator.
   *   - Disables the assignment operator for this class. So if an attempt for
   *     the assignment is made the compiler complains.
   ****************************************************************************/
   fc_audiomanager_tclDiaglogClientHandler_Microphone& operator=
      (const fc_audiomanager_tclDiaglogClientHandler_Microphone &oClientHandler);

   /****************************************************************************
                  Overriding of general CCA methods
   ****************************************************************************/

   /****************************************************************************
                  Overridng of CCA Extension methods
   ****************************************************************************/

   /****************************************************************************
   **              Declare Message Map
   ****************************************************************************/
   /* DESCRIPTION:
   *   The message map is used to "redirect" incoming FI messages to
   *   dedicated handler functions
   ****************************************************************************/

   /****************************************************************************
                  Specific Functions of this class
   ****************************************************************************/

   void vAddObserver();
   virtual void MessageNotification(PO_MessageConfig::enID MsgId);

public:
    tVoid vAdaptDiaglogMicStatus(tU8 MicNr);

    tVoid vSendTestResultToDiaglog(tVoid);

  fc_audiomanager_tclMicrophone_Diagnosis* m_pMainMicDiagApp;

private:

    tVoid vCalculateDTCResult(tU16 u16TroubleCode);

  tVoid vSaveTestResult(tU16 u16TroubleCode, tenTestResult tResult);

   /****************************************************************************
                  Handler Functions for incoming FI messages
   ****************************************************************************/

   /****************************************************************************
                  Member variables of this class
   ****************************************************************************/


    // Save Test results here:
    tTestResultList m_oFiTestResultObject;

    InternalCommunicationAdapter* m_pPO; // Pointer for post office access
    IF_DiagResultHandler* m_poResultHandler;
};

#endif // _fc_audiomanager_DiaglogClientHandler_Microphone_H_

