/*
 * clipping.cpp
 *
 *  Created on: Feb 7, 2013
 *      Author: sss4kor
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>   // implicitly links <osal_if.h>


#include "../../../PostOffice/PostOffice.hpp"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Startup/IDNotifyStartup.h"
#include "InternalComponentCommunication/Messages/Clipping/ID_Clipping_Level.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/Clipping_Level.h"

#include "fc_audiomanager_main.h"

#include "clipping.h"

#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_CLIPPING
#include "trcGenProj/Header/clipping.cpp.trc.h"
#endif

# define AUD_ANALOG_MIN_THD 3980
# define AUD_ANALOG_MAX_THD 2720
# define AUD_ANALOG_DELTA  16
# define ATM_SMALL_CLIP (((AUD_ANALOG_MAX_THD+(3*AUD_ANALOG_DELTA) -AUD_ANALOG_MIN_THD)*5)/16 + AUD_ANALOG_MIN_THD)
# define ATM_HEAVY_CLIP ((((AUD_ANALOG_MAX_THD+(3*AUD_ANALOG_DELTA) -AUD_ANALOG_MIN_THD)*5)/32) +((AUD_ANALOG_MAX_THD+AUD_ANALOG_DELTA+AUD_ANALOG_MIN_THD)/2))
# define ATM_VERY_HEAVY_CLIP (AUD_ANALOG_MAX_THD + AUD_ANALOG_DELTA)

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/
//OSAL_tTimerHandle  Audio_clipping::m_Audio_clippingDelayTimer = 0;






/*************************************************************************
 * FUNCTION:     Audio_clipping::Audio_clipping( )
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
Audio_clipping::Audio_clipping(fc_audiomanager_tclApp* poMainAppl):
                        IF_MessageObserver<PO_MessageConfig::enID>("Audio_clipping observer")
  {
     ETG_TRACE_USR4(("Audio_clipping  constructor"));
     _hAdcAudio=OSAL_ERROR;
     m_blOpenChannel=FALSE;
     m_u32NoOfBlocks=0;
     m_poMainAppl = poMainAppl;
     m_pPO = InternalCommunicationAdapter::getInstance();
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_pPO);

     vAddObserver();


}

/*************************************************************************
 * FUNCTION:     Audio_clipping::~Audio_clipping( )
 *
 * DESCRIPTION:  Destructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
Audio_clipping::~Audio_clipping( )
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);

    m_pPO = NULL;
    vClosechannel();
  }



/*************************************************************************
 * FUNCTION:     Audio_clipping::vAddObserver( )
 *
 * DESCRIPTION:  Observer
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
void Audio_clipping::vAddObserver()
{

   ETG_TRACE_USR4(("Audio_clipping->vAddObserver"));

   if(m_pPO != NULL)
   {
      ETG_TRACE_USR4(("Audio_clipping::vAddObserver  m_pPO != NULL"));
      m_pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyStartup);
      //m_pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_AudioSource);

   }
   else
   {
      FATAL_M_ASSERT_ALWAYS();
   }


}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/

void Audio_clipping::MessageNotification(PO_MessageConfig::enID MsgId)
{
   ETG_TRACE_USR4(("Audio_clipping::MessageNotification entered. "));

   if(MsgId==PO_MessageConfig::ID_NotifyStartup)
      {
         // Obtaining the ADR3 Startup Message from PostOffice handler
         const ID_NotifyStartup* pMsgStartup = m_pPO->POMessages->QueryMessage<ID_NotifyStartup>(MsgId);
         ETG_TRACE_USR4(("ADR3 Startup Observer received state= %x", pMsgStartup->enOn));
         vOpenchannel();

         InternalCommunicationAdapter::POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyRegular100msTicks);
      }
   else if (MsgId == PO_MessageConfig::ID_NotifyRegular100msTicks)
   {
      ETG_TRACE_USR4(("On timer expiry via clipping."));
      vReadAdc();
   }
}




/*************************************************************************
 * FUNCTION:     Audio_clipping::vOpenchannel
 *
 * DESCRIPTION:  This function will Open ADC channel
 *
 * PARAMETER:  tvoid
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid Audio_clipping::  vOpenchannel()
{



    ETG_TRACE_USR4(("vOpenchannel()->Opening ADC Channel"));
    _hAdcAudio = OSAL_IOOpen((tCString)OSAL_C_STRING_DEVICE_ADC_AMP_CLIP,OSAL_EN_READONLY);

    ETG_TRACE_USR4(("vOpenchannel()->_hAdcAudio=%d",_hAdcAudio));
    if(_hAdcAudio ==OSAL_ERROR)
    {
      ETG_TRACE_USR4(("vOpenchannel()->Error in Opening the channel OSAL_C_STRING_DEVICE_ADC_AMP_CLIP"));
      vClosechannel ( );
      m_blOpenChannel=FALSE;
    }
    else
    {
       m_blOpenChannel=TRUE;
       ETG_TRACE_USR4(("vOpenchannel()-> success"));
    }

}
/*************************************************************************
 * FUNCTION:     tunmstr_antdiag_Measuer::vClosechannel
 *
 * DESCRIPTION:  This function will Close ADC channel
 *
 * PARAMETER:  tVoid
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid Audio_clipping::vClosechannel()
{
    ETG_TRACE_USR4(("vClosechannel()-> closing channel"));


      OSAL_s32IOClose ( _hAdcAudio );
      m_blOpenChannel=FALSE;


}
/*************************************************************************
 * FUNCTION:     Audio_clipping::blIsChannelOpen
 *
 * DESCRIPTION:   This function will return true= if requested ADC channel is Open
                 false=If the requested ADC channel is closed
 *
 * PARAMETER:  tVoid
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tBool Audio_clipping::blIsChannelOpen() const
{
  if(m_blOpenChannel==TRUE)
  {
    ETG_TRACE_USR4(("blIsChannelOpen()-> Channel is open"));
  }
  if(m_blOpenChannel==FALSE)
    ETG_TRACE_USR4(("blIsChannelOpen()-> Channel is not open"));

  return m_blOpenChannel;
}

/*************************************************************************
 * FUNCTION:     Audio_clipping::vReadAdc
 *
 * DESCRIPTION:  This function will read the ADC channel
 *
 * PARAMETER:  tU8 u8WhichClient
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid Audio_clipping::vReadAdc(tVoid )
{
  ETG_TRACE_USR4(("vReadAdc()-> reading ADC value"))

    tenclippinglevel enLevel = EN_AUDIO_NO_CLIPPING;
    static tU32 u32AudioADCminblksize = 0;

    tU8 u8NoOfBlocksforadc=1;
    tU16 u16AudioadcSample=0;
    tU16* pu16ReadVal =NULL;
    tU16  *u16ADCValue = NULL;

    tBool blOpenChannel=blIsChannelOpen();
    if( blOpenChannel==TRUE)
    {


        if (u32AudioADCminblksize==0)
        {
          if(OSAL_ERROR == OSAL_s32IOControl(_hAdcAudio,OSAL_C_S32_IOCTRL_SADC_GET_BLOCK_SIZE,(intptr_t)&u32AudioADCminblksize))
          {
            //error in getting block size
            ETG_TRACE_USR4((" vReadAdc()->error in getting block size"));
            return;
          }
        }
        m_u32NoOfBlocks=u32AudioADCminblksize*u8NoOfBlocksforadc;
ETG_TRACE_USR4((" vReadAdc()->_hAdcAudio =%d u32AudioADCminblksize=%d  u8NoOfBlocksforadc=%d",_hAdcAudio,u32AudioADCminblksize,u8NoOfBlocksforadc));

        ETG_TRACE_USR4((" vReadAdc()->m_u32NoOfBlocks=%d",m_u32NoOfBlocks));
        pu16ReadVal = (tPU16)OSAL_pvMemoryAllocate((tU32)m_u32NoOfBlocks);

        if(pu16ReadVal != OSAL_NULL)
         {
        tU32 u32NoOfBytesRead = (tU32)OSAL_s32IORead(_hAdcAudio,(tPS8)pu16ReadVal ,m_u32NoOfBlocks);
        ETG_TRACE_USR4((" vReadAdc()->u32NoOfBytesRead=%d",u32NoOfBytesRead));
        ETG_TRACE_USR4((" vReadAdc()->pu16ReadVal=%p",pu16ReadVal));

        u16ADCValue = (tU16*) pu16ReadVal;
        ETG_TRACE_USR4((" vReadAdc()->u16ADCValue=%d",*u16ADCValue));

        u16AudioadcSample = (tU16) *u16ADCValue;
        ETG_TRACE_USR4((" vReadAdc()->u16AudioadcSample=%d",u16AudioadcSample));
                //// only 12 Bits are valid!


        //// only 12 Bits are valid!
        u16AudioadcSample=u16AudioadcSample&0x0fff;
        ETG_TRACE_USR4((" vReadAdc()->u16AudioadcSample =%d u32AudioADCminblksize=%d ",u16AudioadcSample,u32AudioADCminblksize));


        ETG_TRACE_USR4((" ATM_SMALL_CLIP= %d ",ATM_SMALL_CLIP));
        ETG_TRACE_USR4((" ATM_HEAVY_CLIP=%d",ATM_HEAVY_CLIP));
        ETG_TRACE_USR4((" ATM_VERY_HEAVY_CLIP=%d ",ATM_VERY_HEAVY_CLIP));

        enLevel = enDetermine(u16AudioadcSample);
        //enLevel = EN_AUDIO_NO_CLIPPING;
        ETG_TRACE_USR4((" vReadAdc()-> enDetermine"));
        ETG_TRACE_USR4((" Level sent via PO = %d ",enLevel ));

                         ID_Clipping_Level oClipping_Level(enLevel);
                                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oClipping_Level);





                         ETG_TRACE_USR4((" Sending PO msg"));
                         OSAL_vMemoryFree(pu16ReadVal);
            }

    }
    else
    {
      ETG_TRACE_USR4((" vReadAdc()-> channel not open"));
    }
  }

/*************************************************************************
 * FUNCTION:     Audio_clipping::vReadAdc
 *
 * DESCRIPTION:  This function will read the ADC channel
 *
 * PARAMETER:  tU8 u8WhichClient
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tenclippinglevel Audio_clipping::enDetermine(tU16 u16adcvalue) const
{
 tenclippinglevel enRetLevel;
 enRetLevel=EN_AUDIO_NO_CLIPPING;

                  if(u16adcvalue > (ATM_SMALL_CLIP))
                  {
                   enRetLevel= EN_AUDIO_NO_CLIPPING;
                  }
            else if((u16adcvalue <= (ATM_SMALL_CLIP)) && (u16adcvalue > ATM_HEAVY_CLIP))
            {
               enRetLevel= EN_AUDIO_SMALL_CLIPPING;
            }
            else if((u16adcvalue <= ATM_HEAVY_CLIP) && (u16adcvalue > ATM_VERY_HEAVY_CLIP))
            {
              enRetLevel= EN_AUDIO_MEDIUM_CLIPPING;
            }
            else if(u16adcvalue <= ATM_VERY_HEAVY_CLIP )
            {
               enRetLevel= EN_AUDIO_STRONG_CLIPPING;
            }
            else
            {

            }
          return enRetLevel;
}





