/*******************************************************************************
 *
 * FILE:          sndfile_backend_player.h
 *
 * SW-COMPONENT:  Beep File Player
 *
 * DESCRIPTION:   libsndfile backend for beep file player
 *
 * AUTHOR:        pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/


#ifndef _SNDFILE_BACKEND_PLAYER_H_IF_
#define _SNDFILE_BACKEND_PLAYER_H_IF_
//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#define OSAL_S_IMPORT_INTERFACE_TYPES
//#include "osal_if.h"
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include <alsa/asoundlib.h>
#include <sndfile.h>
#include "beep_player_alsahw.h"
#include "beep_file_reader.h"
#include <pthread.h>

//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#include <stl_pif.h>


#include <string>
#include <map>
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#include "../fc_audiomanager_trace_input.h"
#include "Beep_playback_status_IF.h"
#include "beep_playback_backend_IF.h"

class sndfile_backend_player : public beep_player_backend_IF
{
public:
  //-----------------------------CTOR and DTORs------------------------------
  sndfile_backend_player(Beep_playback_status_IF* m_ptrController);//Constructor
  virtual ~sndfile_backend_player();//Destructor
  tVoid  vTriggerPlayStsUpdate(tU8 u8Sts);

  //----------------------------PLAYER SETUP------------------------------------

  bool         bInitializePlayer();            //Initialize player... once at startup
  bool         bPrepare(const char *p_filePath, const char *p_deviceName, bool bRepeat ,unsigned int recurrence);//Function to be used to play single files
  bool         bUpdateActiveFile(const char* active_file);  //Function to update file during an active playback. Only files with same sampling rates are allowed
  bool         bUpdateRecurrence(int recurrence);      //Function to update recurrence during an acitve playback
  void         vTearDown();                //Tears down the current playback setup, frees resources
  bool         bDeinitPlayer();              //Deinitialize player .. once at shutdown

  //-----------------------------PLAYBACK CONTROL FUNCTIONS---------------------

  bool         bPlay();                  //To start playing
  bool         bStop(beep_player_stop_mode eMode);      //To stop playing

private:
  //----------------------------------Explicit privates-------------------------------------
  sndfile_backend_player();
  sndfile_backend_player(const sndfile_backend_player&);
  //-----------------------------------MEMBER VARIABLES-------------------------------------

  Beep_playback_status_IF*         m_poController;//Pointer to the controller
  beep_player_alsa_device         oDev;//Instance of alsa device
  short int*                 m_buffer;//Buffer to hold the playback data
  pthread_t                 m_worker;//Pthread handle for the worker thread
  bool                   bStopWorker;//Boolean variable... used to stop worker thread
  std::map<std::string,beep_file_reader*>  m_filecollection;//Map to handle the collection of files
  std::string               m_activefile;//Variable that holds the current active file
  tU8 m_bPlayerStatus;
  //-----------------------------------PRIVATE MEMBER FUNCTIONS-----------------------------

  static void*     vWorkerTask(void *arg);//Thead entry function
  beep_player_error   enWriteSamplestoPCM(snd_pcm_t *pcm, sf_count_t period_size, unsigned int periodcount);//Helper function to write to PCM device
  beep_player_error   enReadSamplesFromFile();//Helper function to fill data to the buffer
  beep_file_reader*   pGetActiveReader();//Helper function to get the current active buffer
  void         vCleanupFileCollection();
  void         vPrintPCMState(snd_pcm_state_t state);//Helper function to convert a PCM state to a string and print

};
#endif //#define _SNDFILE_BACKEND_PLAYER_H_IF_


