/*
 * beep_player_alsahw.cpp
 *
 *  Created on: Aug 15, 2016
 *      Author: rjk2kor
 */

#include "beep_player_alsahw.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_BEEP
#include "trcGenProj/Header/beep_player_alsahw.cpp.trc.h"
#endif


beep_player_alsa_device::beep_player_alsa_device()
:m_dev_handle(NULL),
 m_periodsize(0)
,m_channels(2)
,m_buffersize(0)
{

}

beep_player_alsa_device::~beep_player_alsa_device()
{
  if(m_dev_handle)
  {
    snd_pcm_drain(m_dev_handle);
    snd_pcm_close(m_dev_handle);
    m_dev_handle = NULL;
  }
}

bool beep_player_alsa_device::bDeInit()
{
  if(m_dev_handle)
  {
    snd_pcm_drain(m_dev_handle);
    snd_pcm_close(m_dev_handle);
    m_dev_handle = NULL;
  }
  return true;
}

/**
 * Helper function to initialize hardware
 */
bool beep_player_alsa_device::bInitAlsaDev(const char* alsadevname,unsigned int samplerate, unsigned int channels)
{
  if(alsadevname == NULL)
    return false;
  /**
   * Try to Open device
   */
  int err = snd_pcm_open(&m_dev_handle,alsadevname,SND_PCM_STREAM_PLAYBACK,0);
  if(err < 0)
  {
    ETG_TRACE_FATAL(("Failed to open alsa device !!! %s ",alsadevname));
    ETG_TRACE_FATAL(("Open Failed With ERROR : %s ",snd_strerror (err)));;
    return false;
  }
  ETG_TRACE_USR3(("Opened Alsa device successfully"));


  if(bSetHWConfiguration(samplerate,channels))
  {
    ETG_TRACE_USR3(("Hardware Configuration Success. Starting Software configuration "));
    if(bSetSWConfiguration())
    {
      ETG_TRACE_USR3(("Software configuration success, Preparing Alsa device for playback ."));
      //---------------------------- MOVE THE ALSA DEVICE TO PREPARE STATE --------------
      if ((err = snd_pcm_prepare (m_dev_handle)) < 0)
      {
        ETG_TRACE_FATAL(("Init: cannot prepare audio interface for use: %s",snd_strerror (err) ));
      }
      else
      {
        ETG_TRACE_USR3(("Alsa device is ready for use"));
        return true;
      }
    }
    else
    {
      ETG_TRACE_FATAL(("Software configuration failed "));
    }
  }
  else
  {
    ETG_TRACE_FATAL(("Failed to setup hardware configuration"));
  }

  bDeInit();//On success, this line would never be executed

  return false;
}

/**
 * Hepler function to set the configuration of the alsa device
 */
bool beep_player_alsa_device::bSetHWConfiguration(unsigned int samplerate, unsigned int channels)
{
  snd_pcm_hw_params_t *hw_params=NULL;
  int err;

  //Allocate hardware parameter structure
  if((err = snd_pcm_hw_params_malloc(&hw_params)) < 0 )
  {
    ETG_TRACE_FATAL(("Failed to allocate memory of hw parms"));
    return false;
  }
  //Extract the current configuration set
  if ((err = snd_pcm_hw_params_any (m_dev_handle, hw_params)) < 0)
  {
    ETG_TRACE_FATAL(("Init: cannot initialize hardware parameter structure : %s",snd_strerror(err) ));
    snd_pcm_hw_params_free (hw_params);
      return false;
  }
  bool success = true;

  // ---------------------------- MAKE MODIFICATIONS IN CONFIGURATION ----------------------
  success = success && bEnableHWResampling(hw_params);//Enable hardware resampling
  success = success && bSetSampleFormat(hw_params);//Set sample format
  success = success && bSetPCMAccessType(hw_params);//Set access type to rwinterleaved
  success = success && bSetSrcSampleRate(hw_params,samplerate);//Set sample rate
  success = success && bSetChannels(hw_params,channels);//Set number of channels
  success = success && bSetBufferTime(hw_params,BEEP_ALSA_BUFFER_TIME);//Set Buffer size
  success = success && bSetPeriodTime(hw_params,BEEP_ALSA_PERIOD_TIME);//Set Period time

  // ---------------------------- APPLY CHANGES TO HARDWARE ----------------------
  if(success)
  {
    if((err = snd_pcm_hw_params(m_dev_handle,hw_params))< 0)
    {
      success = false;
      ETG_TRACE_FATAL(("Failed to update hardware parameters: %s", snd_strerror(err) ));
    }
    // ----------------------------- Extract required info from Configuration -------------------
    int dir=0;
    snd_pcm_hw_params_get_period_size(hw_params, &m_periodsize, &dir);
    snd_pcm_hw_params_get_buffer_size(hw_params, &m_buffersize);
    snd_pcm_hw_params_get_channels(hw_params,&m_channels);//Get alloted number of channels
    ETG_TRACE_USR3(("AFTER SETUP : Period size : %d, Buffer size :%d, Negotiated channels :%d",m_periodsize,m_buffersize,m_channels));
  }
  //Free memory allocated for hw params
  snd_pcm_hw_params_free (hw_params);

  return success;
}
/**
* Function to setup software configuration
*/
bool beep_player_alsa_device::bSetSWConfiguration()
{
  snd_pcm_sw_params_t *sw_params;
  bool ret = true;
  //TODo : Missing error handling
  ret = ret && bWrap(snd_pcm_sw_params_malloc (&sw_params),"Allocate Memory");
  ret = ret && bWrap(snd_pcm_sw_params_current (m_dev_handle, sw_params),"Get Current SW Params");
  //Set the start threshold. Start threshold means that alsa device will wait till the bytes get filled up
  ret = ret && bWrap(snd_pcm_sw_params_set_start_threshold(m_dev_handle, sw_params, (m_buffersize/m_periodsize)*m_periodsize),"Set SW Start Threshold");
  //Set avail min. As soon as the available frames in buffer reaches the provided size, alsa asks us to fill additional data.
  ret = ret && bWrap(snd_pcm_sw_params_set_avail_min(m_dev_handle, sw_params, m_periodsize),"Set Avail Min");

  //Apply parameters to hardware
  ret = ret && bWrap(snd_pcm_sw_params(m_dev_handle, sw_params),"Apply SW Params");

  //Free resources allocated for swparams
  snd_pcm_sw_params_free (sw_params);
  return ret;
}
/**
 * Helper function to enable hardware resampling
 */
bool beep_player_alsa_device::bEnableHWResampling(snd_pcm_hw_params_t *hw_params)
{
  if(hw_params)
  {
    unsigned int resample = 1;
    int err = snd_pcm_hw_params_set_rate_resample(m_dev_handle,hw_params,resample);
    if(err < 0)
    {
      ETG_TRACE_FATAL(("Resampling setup failed : %s",snd_strerror (err)));
      return false;
    }
    return true;
  }
  return false;
}

bool beep_player_alsa_device::bSetPCMAccessType(snd_pcm_hw_params_t *hw_params)
{
  if(hw_params)
  {
    int err;// Set access to RW interleaved.
    if ((err = snd_pcm_hw_params_set_access (m_dev_handle, hw_params, SND_PCM_ACCESS_RW_INTERLEAVED)) < 0)
    {
      ETG_TRACE_FATAL(("Init: cannot set access type : %s",snd_strerror (err) ));
      return false;
    }
    return true;
  }
  return false;
}
/**
 * Helper function to set sample format
 */
bool beep_player_alsa_device::bSetSampleFormat(snd_pcm_hw_params_t *hw_params)
{
  if(hw_params)
  {
    int err;
    if ((err = snd_pcm_hw_params_set_format (m_dev_handle, hw_params, SND_PCM_FORMAT_S16_LE)) < 0) {
      ETG_TRACE_FATAL(("Init: cannot set Sample Format : %s",snd_strerror (err) ));
      return false;
    }
    return true;
  }
  return false;
}
/**
 * Helper function to enable hardware resampling
 */
bool beep_player_alsa_device::bSetSrcSampleRate(snd_pcm_hw_params_t *hw_params, unsigned int smplrate)
{
  if(hw_params)
  {
    int err;
    //Try to set the sample rate
    if((err = snd_pcm_hw_params_set_rate_near(m_dev_handle,hw_params,(unsigned int*)&smplrate,0))< 0)
    {
      ETG_TRACE_FATAL(("Failed to set rate according to the input file, sample conversion is required. %s",snd_strerror(err) ));
      return false;
    }
    return true;
  }
  return false;
}

bool beep_player_alsa_device::bSetChannels(snd_pcm_hw_params_t *hw_params, unsigned int channels)
{
  if(hw_params)
  {
    int err;
    //Try to set the sample rate
    if((err = snd_pcm_hw_params_set_channels(m_dev_handle,hw_params,channels))< 0)
    {
      ETG_TRACE_FATAL(("Failed to set channels according to the input file, sample conversion is required: %s",snd_strerror (err) ));
    }
    return true;
  }
  return false;
}
bool beep_player_alsa_device::bSetPeriodTime(snd_pcm_hw_params_t *hw_params, unsigned int time_ms)
{
  if(hw_params)
  {
    int err;
    int dir = 1;
    //Try to set the sample rate
    if((err = snd_pcm_hw_params_set_period_time_near(m_dev_handle,hw_params,&time_ms,&dir))< 0)
    {
      ETG_TRACE_FATAL(("Failed to set Period time : %s",snd_strerror (err) ));
      return false;
    }
    return true;
  }
  return false;
}

bool beep_player_alsa_device::bSetBufferTime(snd_pcm_hw_params_t *hw_params, unsigned int time_ms)
{
  if(hw_params)
  {
    int err;
    int dir = 1;
    //Try to set the sample rate
    if((err =  snd_pcm_hw_params_set_buffer_time_near(m_dev_handle,hw_params,&time_ms,&dir))< 0)
    {
      ETG_TRACE_FATAL(("Failed to set Buffer time: %s ",snd_strerror(err) ));
      return false;
    }
    return true;
  }
  return false;
}

bool beep_player_alsa_device::bWrap(int err, const char* str)
{
  if(err < 0)
  {
    ETG_TRACE_FATAL(("Failed to set : %s ",str));
    ETG_TRACE_FATAL(("Failed with Error :%s",snd_strerror(err) ));
    return false;
  }
  return true;
}
