/*
 * beep_file_reader.h
 *
 *  Created on: Aug 26, 2016
 *      Author: rjk2kor
 */

#ifndef BEEP_FILE_READER_H_
#define BEEP_FILE_READER_H_

#include <alsa/asoundlib.h>
#include <sndfile.h>
#include "../Beep_defines.h"
//When the recurrence period is max, then all the samples have to be played
//#define RECURRENCE_PERIOD_MAX    (10)

class beep_file_reader
{
public:
  SNDFILE *m_fptr;
  SF_INFO  m_info;
  //------------------------------CTOR and DTORs-----------------------------------
  beep_file_reader(const char* file_path, bool bLoop=false, int recurrenceperiod=RECURRENCE_PERIOD_MAX);
  virtual ~beep_file_reader();
  //------------------------------READ---------------------------------------------
  sf_count_t uFillBuffer(short int* buffer,sf_count_t frames);//Helper function to fill buffer with req. frames

  //-------------------------------PROPERTY MODIFIERS---------------------------
  bool       bSetRecurrencePeriod(int recurrenceperiod);  //Helper function to update the recurrence period
  void       vSetLoop(bool bEnable);            //Helper function to set whether to loop
  void       vReset();                  //Reset recurrence period
  void       vSetOutputChannels(int channels);      //Set the negotiated number of output channels

  //----------------------------------UTILITY FUNCTIONS--------------------------
  void       vCopySettingsTo(beep_file_reader* x);      //Copy current settings to a different object
  bool       bIsValid();                  //Check if the file reader is valid
private:
  bool       m_bLoop;                  //Loop after end
  sf_count_t     m_playable_samples;              //Logical file end, varies based on recurrence period
  int       m_output_channels;              //Output channels

  beep_file_reader();
  beep_file_reader(const beep_file_reader&);

  //Helper function to convert mono to interleaved stereo or 2 mix 2 non interleaved samples to interleaved sample
  void vMakeInterleavedStereo(const short int* left, const short int* right, short int* output,const size_t samples);
  //Helper function to convert mono to interleaved stereo
  void vInterleavedStereo_To_Mono(const short int* noninterleavedbuf, short int* output,const size_t samples);
};

#endif /* BEEP_FILE_READER_H_ */

